block('i-global')(

    match(function() {
        return !this['i-global'];
    }).def()(function() {
        var params = this['i-global'] = apply('params');

        return applyNext({
            'ctx.params': params
        });
    }),

    mode('params')(function() {
        var data = this.data,
            yDomain = data.yandex_domain,
            login = data.is_beta ?
                data.uname || data.user_login :
                data.display_name ? data.display_name.name : '',
            // все константы в одном месте DIRECT-42220
            consts = this.extend(this.data.CONSTS, applyCtx({
                block: 'i-const'
            }));

        if (login) {
            login = escapeJs(login);
        }

        return this.extend({

            id: 'direct',

            legoVersion: '2.10-45',
            staticVersion: '34.8',
            legoHost: '/node_modules/islands/',
            // для социальной авторизации
            'lego-path': '/node_modules/islands/',

            staticHost: '/',

            social_host: '//social.' + yDomain,

            'secret-key': data.tune_secret_key,

            nonce: data.csp_nonce,

            retpath: data.is_public ?
                data.scheme + '://' + data.server_name + '/dna/' + decodeURIComponent(u.parseUrl(data.current_url).query.context) :
                (data.uname || data.index_page) ? (data.scheme + '://' + data.server_name) : data.SCRIPT,

            'passport-msg': 'direct',

            yandexuid: data.COOKIES && data.COOKIES.yandexuid,

            // login есть всегда при авторизации в Яндексе, но пользователя может не быть в Директе (не выбрана страна и валюта),
            // поэтому также необходимо проверять, что роль !== 'empty'.
            isClientOfDirect: !!login && data.login_rights && data.login_rights.role !== 'empty',

            login: login || (data.COOKIES && data.COOKIES.yandex_login),

            raw_login: data.uname || data.user_login || '',

            oframebust: '{\'*.mtproxy1.yandex.net\': \'\', \'*.mtproxy2.yandex.net\': \'\' }',

            'passport-host': 'https://' + data.passport_domain,

            'pass-host': '//pass.' + yDomain,

            //домен для футера, если нужен домен верхнего уровня, используйте tld
            yandex_domain: '//' + yDomain,

            tld: yDomain.replace('yandex.', ''),

            locale: (data.lang == 'ua') ? 'uk' : data.lang,

            'content-region': (yDomain == 'yandex.com.tr') ? 'tr' : yDomain.substr(7),

            'user-region': (yDomain == 'yandex.com.tr') ? 'tr' : yDomain.substr(7),

            lang: data.lang

        }, consts);
    })
);
