u.register({
    groupTags: {
        /**
         * Возвращает массив тегов группы по идентификаторам группы и массиву тегов кампании
         * @param {Object} groupTags хеш, в котором ключи - идентификаторы меток, а значения - единицы
         * @param {{id: <String>, value: <String>}[]} campaignTags массив тегов кампании
         * @returns {{id: <String>, value: <String>}[]}
         */
        makeTagsArray: function(groupTags, campaignTags) {
            if (groupTags && !u._.isArray(groupTags)) {
                return Object.keys(groupTags).map(function(id) {
                    var cTag = (campaignTags || []).filter(function(tag) {
                        return tag.id == id || tag.tag_id == id;
                    }).pop();

                    return {
                        id: id,
                        value: cTag && cTag.value
                    };
                }, this);
            }
        }
    }
});
