BEM.INTERFACE.decl('i-handle-filter', [

    /**
     * Инициализирует фильтр
     * @description метод вызывается у сущности класса реализующего данный интерфейс для делегирования ему
     * процедуры инициализации фильтра (выставление значений, фокусировка на нужном элемента фильтра и т.п.)
     * @see select_type_with-filters
     * @param {*} param
     */
    'init',

    /**
     * Фильтрует какую либо сущность на основе анализа переданных параметров
     * @description метод вызывается у сущности класса реализующего данный интерфейс для делегирования ему
     * проверки на прохождение фильтруемого элемента; например, передача для проверки значения элемента option
     * при фильтрации по выпадающему списку select: filter(option.val())
     * @see select_type_with-filters
     * @param {*} param
     * @returns {Boolean}
     */
    'filter',

    /**
     * Сбрасывает фильтр к исходным значениям с опциональным обновлением состояния фильтра до актуального
     * @description метод вызывается у сущности класса реализующего данный интерфейс для делегирования ему
     * процесса сброса фильтра к первоначальному или актуальному состоянию; например, передача для сброса
     * фильтра при фильтрации по выпадающему списку select: reset(select.val())
     * @see select_type_with-filters
     * @param {*} [param]
     */
    'reset'
]);
