BEM.DOM.decl('i-height-watcher', {

    onSetMod: {

        js: function() {
            var contentWindow = this.domElem[0].contentWindow.window;

            this.bindToDomElem($(contentWindow), 'resize', $.throttle(this._onWindowIframeResize, 100, this));
        }

    },

    /**
     * Обработчик события resize на окне iframe
     * Тригерит событие change
     * @private
     */
    _onWindowIframeResize: function() {
        this.trigger('change');
    }

}, {

    /**
     * Создает экземпляр блока i-height-watcher
     * @param {jQuery} ctx
     * @returns {BEM}
     */
    getInstance: function(ctx) {
        if (ctx.data('i-height-watcher')) {
            return ctx.data('i-height-watcher');
        } else {
            var watcher;

            ctx.data('i-height-watcher', watcher = this._createInstance(ctx));

            return watcher;
        }
    },

    /**
     * Добавляет iframe в переданный контекст
     * @param {jQuery} ctx
     * @returns {BEM}
     * @private
     */
    _createInstance: function(ctx) {
        var html = $(BEMHTML.apply({
            block: 'i-height-watcher',
            tag: 'iframe',
            js: true
        }));

        this.append(ctx, html);

        return html.bem('i-height-watcher');
    }

});
