BEM.DOM.decl('i-infoblock', {

    onSetMod: {

        js: function() {
            // очередь сообщений
            this._messages = [];

            // список промисов для каждого сообщения
            this._promises = [];

            // таймер отправки запроса
            this._timer = null;
        }

    },

    /**
     * Отправляет сообщение о событии инфоблока
     * @param {String} type тип события
     * @param {*} [data] данные передаваемые с сообщением
     * @returns {$.Deferred}
     */
    sendEventMessage: function(type, data) {
        var _this,
            promise;

        this._timer && window.clearTimeout(this._timer);

        promise = this._addMessage(type, data);

        _this = this;

        this._timer = window.setTimeout(function() {
            var m = _this._messages,
                p = _this._promises;

            _this._sendQueue(
                m.splice(0, m.length),
                p.splice(0, p.length));
        }, 1);

        return promise;
    },

    /**
     * Вызов счетчика бананы
     * Отправлять счетчики нужно для того, чтобы фиксировать в БК факт просмотра и закрытия баннера
     * Не требует какой-то реакции в ответ на запрос
     * @param {String} url адрес счетчика
     */
    _sendCounter: function(url) {
        BEM.create('i-request_type_ajax', {
            url: url,
            type: 'GET',
            cache: false,
            dataType: 'text',
            xhrFields: {
                withCredentials: true
            }
        }).get({}, function() {
            // noop
        });
    },

    /**
     * Возвращает новости из инфоблока
     * @returns {Promise}
     */
    getNews: function() {
        return new Promise(function(resolve, reject) {
            this
                .sendEventMessage('require-events', {})
                .done(function(data) {
                    resolve(data.news.items);
                })
                .fail(function() {
                    resolve([]);
                });
        }.bind(this));
    },

    /**
     * Задаёт URL, куда будут слаться сообщения инфоблока
     * @param {String} url
     * @protected
     */
    _setMessagesURL: function(url) {
        this._url = url;
    },

    /**
     * Задаёт метаинформацию отправляемую с очередью сообщений (например, uid)
     * @param {Object} data
     * @protected
     */
    _setMetadata: function(data) {
        this._data = data;
    },

    /**
     * Добавляет сообщение в очередь на отправку
     * @param {String} type тип события
     * @param {*} [data] данные передаваемые с сообщением
     * @returns {$.Deferred}
     * @private
     */
    _addMessage: function(type, data) {
        var uniqId = $.identify(),
            deferred = $.Deferred();

        deferred.uniqId = uniqId;

        this._promises.push(deferred);

        this._messages.push({
            uniqId: uniqId,
            type: type,
            data: data
        });

        return deferred.promise();
    },

    /**
     * Отправляет очередь сообщений
     * @param {Object[]} messages массив объектов с сообщениями
     * @param {$.Deferred[]} promises массив промисов
     * @private
     */
    _sendQueue: function(messages, promises) {
        if (!this._url) throw new Error('Request URL not specified');

        BEM.create('i-request_type_ajax', {
            url: this._url,
            type: 'POST',
            cache: false,
            dataType: 'json',
            // общение через JSON
            paramsToSettings: ['contentType'],
            contentType: 'application/json; charset=utf-8'
        }).get(
            JSON.stringify(u._.extend({}, this._data, $.ajaxSettings.data, { queue: messages })),
            function(response) {
                response = response.reduce(function(hash, answer) {
                    hash[answer.uniqId] = answer;

                    return hash;
                }, {});

                promises.forEach(function(promise) {
                    var answer = response[promise.uniqId] || { error: { message: 'No Answer Error' } };

                    answer.error ?
                        promise.reject(new Error(answer.error.message)) :
                        promise.resolve(answer.result);
                });
            },
            // обработка общих ошибок (сервер упал, метеориты и т.п.)
            function() {
                var error = new Error('Internal Server Error');

                promises.forEach(function(promise) {
                    promise.reject(error);
                });
            });
    }

});
