(function() {
    //стили для подсветки live-инициализируемых блоков, которые проинициализированны к окончанию загрузки страницы
    var LIVE_INITED_STYLES = [
            '0 0 5px #60b88d',
            '0 0 10px #90cdaf',
            '0 0 15px #bfe3d1'
        ],
        //стили для подсветки НЕ live-инициализируемых блоков, которые проинициализированны к окончанию загрузки страницы
        NOT_LIVE_INITED_STYLES = [
            '0 0 5px #f00',
            '0 0 10px #ce5f48',
            '0 0 15px #ffc1c9'
        ];

    BEM.DOM.decl('i-inited-highlight', {

        onSetMod: {
            js: function() {
                $('.i-bem').filter(function(i, elem) { return elem.className.match(/(\w)+_js_inited/) })
                    .each(this._highlightBlocks.bind(this));
            }
        },

        /**
         * Добавляет стили dom-ноде согласно найденным на ней bem-блокам
         * @param {Number} i
         * @param {Object} domElem
         * @private
         */
        _highlightBlocks: function(i, domElem) {
            var blocksNamesArray = u._.keys(BEM.DOM.extractParams(domElem));

            blocksNamesArray.forEach(function(name, index) {
                this._buildCss(domElem, this._isLiveInitable(name), index);
            }, this);
        },

        /**
         * Добавляет стиль к dom-ноде в соответствии с конкретным bem-блоком на ней
         * @param {Object} domElem дом нода
         * @param {Boolean} isLiveInitable является ли bem-блок live-инициализированным
         * @param {Number} index
         * @private
         */
        _buildCss: function(domElem, isLiveInitable, index) {
            $(domElem).css({
                'box-shadow': (isLiveInitable ? LIVE_INITED_STYLES : NOT_LIVE_INITED_STYLES)[index % 3]
            });
        },

        /**
         * Является ли bem-блок live-инициализированным
         * @param {String} blockName имя блока
         * @returns {Boolean}
         * @private
         */
        _isLiveInitable: function(blockName) {
            return BEM.blocks[blockName]._liveInitable;
        }

    }, {});
})();
