/**
 * @property {BEMJSON} this.ctx.content содержимое ссылки
 * @property {Object} this.ctx.params параметры, с которыми выстрелит событие "add" i-list-а
 */
block('i-list-controls').elem('add').def()(function() {
    return applyCtx({
        block: 'link',
        mix: (function() {
            var mix = this.ctx.mix || [];

            if (!Array.isArray(mix)) { mix = [mix]; }

            mix.push(
                {
                    block: 'i-list',
                    elem: 'control',
                    elemMods: { action: 'add' },
                    js: this.ctx.params
                },
                {
                    block: 'i-list-controls',
                    elem: 'add'
                });

            return mix;
        }.call(this)),
        mods: {
            pseudo: 'yes',
            inner: 'yes'
        },
        content: [
            {
                block: 'b-icon',
                mix: [{
                    block: 'i-list-controls',
                    elem: 'add-icon'
                }],
                mods: { 'size-13': 'plus-sign' }
            },
            {
                elem: 'inner',
                mix: [{
                    block: 'i-list-controls',
                    elem: 'add-text'
                }],
                content: this.ctx.content || iget2('i-list-controls', 'dobavit', 'Добавить')
            }
        ]
    });
});
