/**
 * Блок-обработчик для кнопки "Видеодополнения" в массовых действиях на кампании
 * Триггерит событие 'closed' для блока b-mass-actions_type_camps, который
 * уничтожает блок
 */
BEM.decl('i-mass-action-video-extension', {
    onSetMod: {
        js: function() {
            this._cids = this.params.cids;

            this._subMan = BEM.create('i-subscription-manager');
        }
    },

    /**
     * Открывает попап со счетчиками метрики
     */
    openPopup: function() {
        this._initPopup().then(function() {
            this._popup.show();
        }.bind(this));
    },

    /**
     * Деструтор
     */
    destruct: function() {
        this._subMan.dispose();
        this.__base.apply(this, arguments);
    },

    /**
     * инициализация попап
     * @returns {BEM}
     * @private
     */
    _initPopup: function() {
        var promise = $.Deferred(),
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                dataType: 'json',
                type: 'POST',
                callbackCtx: this,
                cache: false
            });

        request.get({
            ulogin: u.consts('ulogin') || '',
            cmd: 'searchTextVideoCreatives'
        }, function(data) {
            this._popup = BEM.DOM.blocks['b-modal-popup-decorator'].create(null, { bodyScroll: false });
            this._videoExtension = this._popup.setPopupContent({
                block: 'b-mass-action-video-extension-popup',
                creatives: data.result.creatives || [],
                readonly: this.params.readonly
            });

            this._initEvents();

            promise.resolve();
        });

        return promise;
    },

    /**
     * инициализирует события на попапе
     * @private
     */
    _initEvents: function() {
        var popup = this._popup,
            videoExtension = this._videoExtension;

        this._subMan.wrap(videoExtension)
            .on('replace', function(event, extension) {
                this._onVideoExtensionAction('replace', extension);
            }, this)
            .on('remove', function() {
                this._onVideoExtensionAction('remove');
            }, this)
            .on('cancel', function() {
                popup.hide({ force: true });
            }, this);

        this._subMan.wrap(popup)
            .on('close', function() {
                popup.destruct();
                this.trigger('closed');
            }, this);

    },

    /**
     * Обработка кнопок на попапе (добавить-заменить-удалить)
     * @param {String} action - тип действия над попапом
     * @param {String} [extension] - список видеодополнений
     * @private
     */
    _onVideoExtensionAction: function(action, extension) {
        var popup = this._popup,
            request = BEM.create('i-request_type_ajax', {
                url: '/registered/main.pl',
                dataType: 'json',
                type: 'POST',
                callbackCtx: this,
                cache: false
            });

        BEM.blocks['b-metrika2'].params({
            params: {
                ShowCamps: {
                    massAction: 'videoExtension-' + action
                }
            }
        });

        request.get({
            cmd: 'ajaxSetAutoResources',
            cid: this._cids,
            action: action === 'remove' ? 'reset' : 'set',
            ulogin: u.consts('ulogin') || '',
            creative_id: extension
        }, function() {
            BEM.blocks['b-user-dialog'].alert({
                message: iget2('i-mass-action-video-extension', 'video-for-selected-camps', 'Видеодополнения {action} для выбранных кампаний', {
                    action: action === 'remove' ?
                        iget2('i-mass-action-video-extension', 'deleted', 'удалены') :
                        iget2('i-mass-action-video-extension', 'zadanu', 'заданы')
                }),
                onCancel: function() {
                    popup.hide({ force: true });
                }
            });
        }, function() {
            var message = action === 'remove' ?
                iget2('i-mass-action-video-extension', 'error-pri-ydalenii', 'При удалении видеодополнений произошла ошибка. Попробуйте еще раз.') :
                iget2('i-mass-action-video-extension', 'error-pri-dobavlenii', 'При добавлении видеодополнений произошла ошибка. Попробуйте еще раз.');

            BEM.blocks['b-confirm'].alert(message);
        });
    }

});
