(function() {
    var controllersParams = {
        getGeoRestrictions: {
            bulkKey: 'json_data',
            extraParams: {
                ulogin: u.consts('ulogin')
            }
        },
        ajaxCheckUrlMass: {
            bulkKey: 'json_data',
            debounceTimeout: 1000, //таймаут не нулевой, потому что использующие блоки запрашивают ajaxCheckUrlMass асинхронно
            timeout: 100000 // если баннеров много, то запрос идет очень долго
        },
        ajaxValidateStreet: {
            bulkKey: 'json_data'
        }
    };

    BEM.decl('i-mass-request-factory', {}, {
        /**
         * Словарь экземпляров блока, соответствующих разным cmd
         * @type {Object}
         */
        _requestsCache: {},

        /**
         * Возвращает экземпляр блока запроса по имени контроллера
         * @param {String} cmd имя контроллера
         * @returns {i-mass-request-instance}
         */
        getInstanceFor: function(cmd) {
            var blockParams = { cmd: cmd },
                controllerParams = controllersParams[cmd];

            ['bulkKey', 'debounceTimeout', 'timeout', 'extraParams'].forEach(function(key) {
                blockParams[key] = controllerParams[key];
            });

            if (!this._requestsCache[cmd]) {
                this._requestsCache[cmd] = BEM.create('i-mass-request', blockParams);
            }
            return this._requestsCache[cmd];
        }
    });
}());
