r103379
# Блок совершения "массовых" запросов #

## Общие сведения ##

Идея блока в том, чтобы иметь механизм объединения запросов на один контроллер в один большой запрос
Этот формат "большого" запроса поддерживается на сервере (или создается рядом другой контроллер, который умеет понимать такие запросы)
Контроллер возвращает ответ сразу на все запросы, и этот ответ разбирается на части и рассылается совершавшим запрос

### Пример ###

Скажем, на сервере есть некий контроллер **getRegion** который возвращает регион, в котором показывается объявление

    > GET /getRegion?bid=1
    < { regionId: 216 }

"Массовая" версия такого контроллера, **massGetRegion** будет выглядеть вот так

    > POST /massGetRegion
    >
    > json_banners=[{ bid: 1 }, { bid: 2 }]
    < [
    <   { bid: 1, regionId: 216 },
    <   { bid: 2, regionId: 121 }
    < ]

Запрос поменялся на POST, потому что контроллеры, принимающие json не отвечают на GET

## Использование ##

Использующий блок создает экземпляр запроса (`i-mass-request`)...

`var request = BEM.blocks['i-mass-request-factory'].getInstanceFor('getGeoRestrictions');`

...а затем вызывает обычным образом, как `i-request`

`request.get(data, onSuccess, onError)`

В отличии от i-request нельзя передавать 4 параметр - опции запроса, они уже все сформированы блоком `i-mass-request-factory`
Нужно иметь в виду, что запросов выполнится не в момент вызова `get`, а по окончанию таймаута debounce

Больше примеров использование - в тестах `i-mass-request`

За историей возникновения можно обратиться в [DIRECT-37521](https://st.yandex-team.ru/DIRECT-37521)
