BEM.decl('i-meaningful-goals-dataprovider', {
}, {
    /**
     * Отправляет запрос на получение списка доступных ключевых целей
     * @param {String} campaignId идентификатор кампании
     * @param {String} metrikaCounters идентификаторы счетчиков метрики через запятую
     * @returns {Promise}
     */
    getGoals: function(campaignId, metrikaCounters) {
        var _this = this;

        return new Promise(function(resolve, reject) {
            var request = _this._getRequest();

            request.get({
                cmd: 'ajaxSuggestMeaningfulGoals',
                cid: campaignId,
                metrika_counters: metrikaCounters,
                csrf_token: u.consts('csrf_token'),
                ulogin: u.consts('ulogin')
            },function(response) {
                resolve(response.data);
            }, function(data) {
                reject(data);
            });
        });
    },

    /**
     * Возвращает экземпляр блока i-request_type_ajax
     * @param {Object} [params] параметры запроса
     * @returns {BEM}
     * @private
     */
    _getRequest: function(params) {

        return BEM.create('i-request_type_ajax', u._.extend({
            url: '/registered/main.pl',
            dataType: 'json',
            type: 'POST',
            cache: false,
            callbackCtx: this
        }, params));
    }
});
