block('i-mo-decl').mod('type', 'ext-phrases').def()(function() {
    var data = this.data,
        isMultipleCampaigns = !data.FORM.single_camp,
        availableCampTypes = data.available_camp_types || [],
        campType = (data.campaign || {}).type,
        showTrafficVolumeStat = u['traffic-volume'].showTrafficVolumeStatFieldsMO(isMultipleCampaigns ? availableCampTypes : campType),
        showCondition = function(item) {
            return typeof item === 'string' || (item.hasOwnProperty('showCondition') ? item.showCondition : true);
        };

    return {
        columns: u._.filter([
            'shows',
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            'fp_shows_avg_pos',
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            'fp_clicks_avg_pos',
            {
                name: 'bounce_ratio',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            {
                name: 'adepth',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            'aconv',
            'agoalcost',
            'agoalnum',
            'agoalroi',
            'agoalincome'
        ], showCondition),
        slices: u._.filter([
            {
                name: 'contextcond_orig',
                lock: ['contextcond_orig']
            },
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // 'ext_phrase_status',
            'bm_type',
            {
                name: 'sim_distance',
                showCondition: hasLoginRights('super_control', 'superreader_control')
            },
            {
                name: 'campaign_type',
                showCondition: isMultipleCampaigns
            },
            {
                name: 'campaign',
                showCondition: isMultipleCampaigns
            },
            {
                name: 'adgroup',
                lock: ['adgroup']
            },
            'banner'
        ], showCondition),
        filters: u._.filter([
            {
                name: 'campaign_type',
                showCondition: isMultipleCampaigns
            },
            {
                name: 'campaign',
                showCondition: isMultipleCampaigns
            },
            {
                name: 'campaign_strategy',
                showCondition: isMultipleCampaigns
            },
            'adgroup',
            'banner',
            {
                name: 'bm_type',
                showCondition: isMultipleCampaigns || (campType !== 'dynamic' && campType !== 'performance')
            },
            {
                name: 'phrase_orig',
                showCondition: isMultipleCampaigns || campType !== 'dynamic'
            },
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // {
            //     name: 'ext_phrase_status',
            //     showCondition: (isMultipleCampaigns || campType !== 'dynamic')
            // },
            {
                name: 'sim_distance',
                showCondition: hasLoginRights('super_control', 'superreader_control') &&
                    (isMultipleCampaigns || (campType !== 'performance'))
            },
            'goal_id',

            // Filters for columns
            'shows',
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            'fp_shows_avg_pos',
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            'fp_clicks_avg_pos',
            {
                name: 'bounce_ratio',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            {
                name: 'adepth',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            'aconv',
            'agoalnum',
            'agoalcost',
            'agoalroi',
            'agoalincome'
        ], showCondition)
    };
});
