block('i-mo-decl').mod('type', 'moc').def()(function() {
    var data = this.data,
        campType = (data.campaign || {}).type,
        showTrafficVolumeStat = u['traffic-volume'].showTrafficVolumeStatFieldsMO(campType),
        isAgencyClient = !!u._.get(data, 'campaign.AgencyUID'),
        isInternalCamp = u.campaign.isInternal(campType),
        showAbSegments = !!data.is_ab_segments_enabled && campType !== 'mobile_content',
        showAvgTimeToConversion = hasLoginRights('super_control', 'manager_control', 'support_control', 'superreader_control', 'is_superteamleader', 'is_teamleader'),
        // Столбики про квантили досмотра нужны и для in-banner креативов, которые в баннерной группе
        allowedQuartilesData = u._.includes(['cpm_banner'], campType),
        allowedVastEvents = (u.consts('rights').allowedCpmVideoBanners && u._.includes(['cpm_banner', 'cpm_price'], campType)),
        isContentPromotion = campType === 'content_promotion',
        isContentPromotionVideo = data.content_promotion_content_type === 'video',
        allowedInternals = u.consts('rights').enableInternalCampaigns && isInternalCamp,
        allowedMrcVisibility = u._.includes(['cpm_banner', 'cpm_price', 'cpm_deals', 'cpm_yndx_frontpage'], campType),
        allowedContentTargeting = hasEnabledFeatures('content_category_targeting_cpc') && u._.includes(['text'], campType) ||
            u._.includes(['cpm_banner', 'cpm_price'], campType),
        showCondition = function(item) {
            return typeof item === 'string' || (item.hasOwnProperty('showCondition') ? item.showCondition : true);
        },
        showCpmAuctionStats = hasEnabledFeatures('cpm_banner_sov_in_stat') && u.campaign.isCpm(campType),
        operatorFeatures = data.features_enabled_for_operator_all,
        showAuctionStats = operatorFeatures && operatorFeatures.includes('AUCTION_STATS_FOR_ALL_CAMPAIGNS'),
        isAutobudgetAvgCpvCustomPeriod = u._.get(data, 'campaign.strategy.net.name') === 'autobudget_avg_cpv_custom_period',
        allowedAvgNShowColumns = u._.includes(['cpm_banner', 'cpm_price', 'cpm_yndx_frontpage'], campType) &&
            (hasEnabledFeatures('avg_nshow_for_cpm_campaigns_in_moc') || (hasEnabledFeatures('avg_nshow_for_strategy_in_moc') && isAutobudgetAvgCpvCustomPeriod)),
        allowedAvgNShowCompleteColumns = u._.includes(['cpm_banner', 'cpm_price', 'cpm_yndx_frontpage'], campType) &&
            (hasEnabledFeatures('avg_nshow_complete_for_cpm_campaigns_in_moc') || (hasEnabledFeatures('avg_nshow_complete_for_strategy_in_moc') && isAutobudgetAvgCpvCustomPeriod)),
        isPostViewAvailable = u.campaign.isCpm(campType) && hasEnabledFeatures('post_view_statistics');

    return {
        columns: u._.filter([
            'shows',
            {
                name: 'avg_nshow',
                showCondition: allowedAvgNShowColumns
            },
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            {
                name: 'avg_cpm',
                showCondition: u.campaign.isCpm(campType)
            },
            {
                name: 'fp_shows_avg_pos',
                showCondition: !u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage'], campType)
            },
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            {
                name: 'fp_clicks_avg_pos',
                showCondition: !u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage'], campType)
            },
            {
                name: 'cpm_winrate',
                showCondition: false
            },
            {
                name: 'uniq_viewers',
                disable: [
                    'tags', 'contextcond_orig', 'criterion_type', 'match_type', 'retargeting_coef', 'page_group',
                    'page', 'physical_region', 'banner_image_type', 'image_size', 'content_targeting'
                ],
                showCondition: u.campaign.isCpm(campType)
            },
            {
                name: 'uniq_users_winrate',
                showCondition: false
            },
            {
                name: 'avg_view_freq',
                disable: [
                    'tags', 'contextcond_orig', 'criterion_type', 'match_type', 'retargeting_coef', 'page_group',
                    'page', 'physical_region', 'banner_image_type', 'image_size', 'content_targeting'
                ],
                showCondition: u.campaign.isCpm(campType)
            },
            // https://st.yandex-team.ru/DIRECT-67514: пока убираем для mcbanner
            {
                name: 'winrate',
                showCondition: campType === 'performance',
                disable: [
                    'tags',
                    'banner',
                    'gender',
                    'age',
                    'connection_type',
                    'detailed_device_type',
                    'banner_type',
                    'image_size',
                    'banner_image_type',
                    'retargeting_coef'
                ]
            },
            {
                name: 'bounce_ratio',
                showCondition: campType !== 'mobile_content'
            },
            {
                name: 'adepth',
                showCondition: campType !== 'mobile_content' && campType !== 'performance'
            },
            {
                name: 'avg_time_to_conv',
                showCondition: showAvgTimeToConversion
            },
            'aconv',
            'agoalcost',
            'agoalnum',
            'agoalroi',
            {
                name: 'agoalcrr',
                showCondition: hasEnabledFeatures('crr_strategy_allowed')
            },
            'agoalincome',
            'agoals_profit',
            {
                name: 'aprgoodmultigoal',
                showCondition: !isContentPromotion
            },
            {
                name: 'aprgoodmultigoal_cpa',
                showCondition: !isContentPromotion
            },
            {
                name: 'aprgoodmultigoal_conv_rate',
                showCondition: !isContentPromotion
            },
            {
                name: 'avg_bid',
                showCondition: hasEnabledFeatures('avg_bid_in_mol')
            },
            {
                name: 'auction_win_rate', // Доля выигрышей
                showCondition: showCpmAuctionStats || showAuctionStats,
                disable: [
                    'tags', 'adgroup', 'banner', 'banner_type', 'contextcond_orig', 'retargeting_coef',
                    'targettype', 'page_group', 'page', 'deal', 'ssp', 'physical_region', 'position',
                    'click_place', 'banner_image_type', 'image_size', 'turbo_page_type', 'detailed_device_type',
                    'connection_type', 'gender', 'targeting_category', 'age', 'contexttype_orig', 'criterion_type',
                    'match_type', 'inventory_type', 'place_id', 'place_description', 'operating_system', 'browser',
                    'page_id', 'content_targeting'
                ]
            },
            {
                name: 'imp_reach_rate', // SOV
                showCondition: showCpmAuctionStats,
                disable: [
                    'tags',
                    'contextcond_orig',
                    'criterion_type',
                    'match_type',
                    'retargeting_coef',
                    'page_group',
                    'page',
                    'physical_region',
                    'banner_image_type',
                    'image_size'
                ]
            },
            {
                name: 'auction_wins', // Выигрыши в аукционах
                showCondition: showCpmAuctionStats,
                disable: [
                    'tags', 'adgroup', 'banner', 'banner_type', 'contextcond_orig', 'retargeting_coef',
                    'targettype', 'page_group', 'page', 'deal', 'ssp', 'physical_region', 'position',
                    'click_place', 'banner_image_type', 'image_size', 'turbo_page_type', 'detailed_device_type',
                    'connection_type', 'gender', 'targeting_category', 'age', 'contexttype_orig', 'criterion_type',
                    'match_type', 'inventory_type', 'place_id', 'place_description', 'operating_system', 'browser',
                    'page_id', 'content_targeting'
                ]
            },
            {
                name: 'auction_hits', // Участие в аукционах
                showCondition: showCpmAuctionStats,
                disable: [
                    'tags', 'adgroup', 'banner', 'banner_type', 'contextcond_orig', 'retargeting_coef',
                    'targettype', 'page_group', 'page', 'deal', 'ssp', 'physical_region', 'position',
                    'click_place', 'banner_image_type', 'image_size', 'turbo_page_type', 'detailed_device_type',
                    'connection_type', 'gender', 'targeting_category', 'age', 'contexttype_orig', 'criterion_type',
                    'match_type', 'inventory_type', 'place_id', 'place_description', 'operating_system', 'browser',
                    'page_id', 'content_targeting'
                ]
            },
            {
                name: 'served_impressions', // Число выхода рекламы для outDoor && inDoor
                showCondition: campType === 'cpm_banner',
                disable: [
                    'tags',
                    'contextcond_orig',
                    'criterion_type',
                    'match_type',
                    'retargeting_coef',
                    'page',
                    'physical_region',
                    'banner_image_type',
                    'image_size',
                    'device_type'
                ]
            },
            {
                name: 'uniq_completed_viewers', // Достроенный охват для outDoor
                showCondition: u._.includes(['cpm_banner', 'cpm_price'], campType),
                disable: [
                    'tags',
                    'contextcond_orig',
                    'criterion_type',
                    'match_type',
                    'retargeting_coef',
                    'page',
                    'page_group',
                    'physical_region',
                    'banner_image_type',
                    'image_size',
                    'device_type',
                    'inventory_type'
                ]
            },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_first_quartile' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_first_quartile_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_midpoint' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_midpoint_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_third_quartile' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_third_quartile_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_complete' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_complete_rate' },
            {
                name: 'avg_nshow_complete',
                showCondition: allowedAvgNShowCompleteColumns
            },
            { showCondition: (allowedQuartilesData || allowedVastEvents || isContentPromotionVideo) && hasEnabledFeatures('cpv_strategies_enabled'), name: 'video_true_view' },
            { showCondition: (allowedQuartilesData || allowedVastEvents || isContentPromotionVideo) && hasEnabledFeatures('cpv_strategies_enabled'), name: 'video_avg_true_view_cost' },
            { showCondition: (allowedQuartilesData || allowedVastEvents || isContentPromotionVideo) && hasEnabledFeatures('cpv_strategies_enabled'), name: 'video_true_view_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents, name: 'video_mute' },
            { showCondition: allowedQuartilesData || allowedVastEvents, name: 'video_unmute' },
            { showCondition: allowedQuartilesData || allowedVastEvents, name: 'cpcv' },
            {
                showCondition: isContentPromotionVideo || u._.includes(['cpm_price', 'cpm_banner'], campType),
                name: 'ad_site_clicks'
            },
            { showCondition: allowedInternals, name: 'close_clicks' },
            { showCondition: allowedInternals, name: 'close_ctr' },
            { showCondition: allowedMrcVisibility, name: 'viewable_impressions_mrc' },
            { showCondition: allowedMrcVisibility, name: 'nonviewable_impressions_mrc' },
            { showCondition: allowedMrcVisibility, name: 'undetermined_impressions_mrc' },
            { showCondition: allowedMrcVisibility, name: 'measured_rate_mrc' },
            { showCondition: allowedMrcVisibility, name: 'viewable_rate_mrc' }
        ], showCondition),

        slices: u._.filter([
            'tags',
            'adgroup',
            'banner',
            {
                name: 'banner_type',
                showCondition: u.campaign.isCpm(campType) ?
                    u.consts('rights').enableCpmStatistics2 :
                    !u._.contains(['performance', 'dynamic', 'mcbanner', 'content_promotion'], campType),
                disable: ['winrate']
            },
            {
                name: 'contextcond_orig',
                disable: campType === 'performance' ? ['shows', 'eshows', 'ctr', 'ectr', 'fp_shows_avg_pos', 'avg_x'] : [],
                lock: campType === 'performance' ? ['winrate'] : []
            },
            {
                name: 'retargeting_coef',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'targettype',
                showCondition: !u._.contains([
                    'mcbanner',
                    'cpm_banner',
                    'cpm_deals',
                    'cpm_yndx_frontpage',
                    'content_promotion'
                ], campType)
            },
            {
                name: 'page_group',
                disable: ['page', 'content_targeting'],
                lock: campType === 'mcbanner' ? [] : ['targettype']
            },
            {
                name: 'page',
                showCondition: hasLoginRights('super_control', 'superreader_control', 'support_control'),
                disable: ['page_group', 'content_targeting'],
                lock: campType === 'mcbanner' ? [] : ['targettype']
            },
            {
                name: 'deal',
                showCondition: (hasLoginRights('super_control') ||
                    (hasEnabledFeatures('cpm_deals') && hasLoginRights('agency_control'))) &&
                        isAgencyClient && campType === 'cpm_deals'
            },
            {
                name: 'ssp',
                showCondition: u.campaign.isCpm(campType) ?
                    u.consts('rights').enableCpmStatistics :
                    !u._.contains(['mcbanner', 'content_promotion'], campType),
            },
            {
                name: 'strategy_id',
                showCondition: hasEnabledFeatures('package_strategies_stage_two')
            },
            'region',
            'physical_region',
            {
                name: 'region_source',
                showCondition: hasEnabledFeatures('advanced_geotargeting_stat')
            },
            {
                name: 'position',
                showCondition: !u._.contains([
                    'performance',
                    'mcbanner',
                    'cpm_banner',
                    'cpm_deals',
                    'cpm_yndx_frontpage',
                    'content_promotion'
                ], campType)
            },
            {
                name: 'click_place',
                showCondition: u.campaign.isCpm(campType) ?
                    u.consts('rights').enableCpmStatistics2 :
                    !u._.contains(['performance', 'mcbanner'], campType),
                disable: [
                    'shows', 'eshows', 'ctr', 'ectr', 'fp_shows_avg_pos', 'avg_x', 'uniq_viewers', 'avg_view_freq',
                    'video_first_quartile', 'video_midpoint', 'video_midpoint_rate', 'video_complete',
                    'video_first_quartile_rate', 'video_midpoint_rate', 'video_third_quartile',
                    'video_third_quartile_rate', 'video_complete_rate', 'avg_cpm', 'cpcv', 'ad_site_clicks',
                    'viewable_impressions_mrc', 'nonviewable_impressions_mrc', 'undetermined_impressions_mrc',
                    'measured_rate_mrc', 'viewable_rate_mrc'
                ]
            },
            {
                name: 'banner_image_type',
                showCondition: !u._.contains(['dynamic', 'content_promotion'], campType)
            },
            {
                name: 'image_size',
                showCondition: !u._.contains(['dynamic', 'mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'turbo_page_type',
                showCondition: u.consts('isTurboPageTypesInMolEnabled')
            },
            {
                name: 'device_type',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'detailed_device_type',
                showCondition: campType === 'mobile_content' ||
                    u.campaign.isCpm(campType) && u.consts('rights').enableCpmStatistics
            },
            {
                name: 'connection_type',
                showCondition: campType === 'mobile_content' ||
                    u.campaign.isCpm(campType) && u.consts('rights').enableCpmStatistics
            },
            'gender',
            'targeting_category',
            {
                name: 'prisma_income_grade',
                showCondition: u.consts('isIncomeGradeBidModifierEnabled')
            },
            'age',
            {
                name: 'contexttype_orig',
                showCondition: !u.campaign.isCpm(campType)
            },
            {
                name: 'criterion_type',
                showCondition: u.campaign.isCpm(campType)
            },
            'match_type',
            {
                name: 'inventory_type',
                showCondition: u.consts('rights').allowedCpmVideoBanners && u._.includes(['cpm_banner', 'cpm_price'], campType),
                disable: [
                    'aprgoodmultigoal',
                    'aprgoodmultigoal_cpa',
                    'aprgoodmultigoal_conv_rate',
                    'avg_time_to_conv',
                ]
            },
            { showCondition: allowedInternals, name: 'place_id' },
            { showCondition: allowedInternals, name: 'place_description' },
            { showCondition: allowedInternals, name: 'operating_system' },
            { showCondition: allowedInternals, name: 'browser' },
            { showCondition: allowedInternals, name: 'page_id' },
            {
                name: 'content_targeting',
                showCondition: allowedContentTargeting,
                disable: [
                    'page', 'page_group', 'eshows', 'avg_bid', 'fp_shows_avg_pos', 'avg_x', 'fp_clicks_avg_pos',
                    'auction_hits', 'auction_wins', 'auction_win_rate', 'imp_reach_rate', 'served_impressions',
                    'uniq_viewers', 'uniq_completed_viewers', 'avg_view_freq', 'video_mute', 'video_unmute', 'avg_x'
                ]
            }
        ], showCondition),

        filters: u._.filter([
            'tags',
            'adgroup_id',
            'adgroup',
            'adgroup_status',
            'banner',
            'banner_status',
            {
                name: 'banner_type',
                showCondition: u.campaign.isCpm(campType) ?
                    u.consts('rights').enableCpmStatistics2 :
                    !u._.contains(['performance', 'dynamic', 'mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'contexttype_orig',
                showCondition: campType !== 'performance' && campType !== 'dynamic' && campType !== 'mcbanner' &&
                    !u.campaign.isCpm(campType)
            },
            {
                name: 'criterion_type',
                showCondition: u.campaign.isCpm(campType)
            },
            {
                name: 'match_type',
                showCondition: !u._.contains(['mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'phrase_orig',
                showCondition: campType !== 'performance' && campType !== 'dynamic'
            },
            {
                name: 'rmp_interest',
                showCondition: campType === 'mobile_content'
            },
            {
                name: 'retargeting',
                showCondition: !u._.contains(['performance', 'dynamic', 'mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'retargeting_coef',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'deal_export_id',
                showCondition: (hasLoginRights('super_control') ||
                    (hasEnabledFeatures('cpm_deals') && hasLoginRights('agency_control'))) &&
                        isAgencyClient && campType === 'cpm_deals'
            },
            {
                name: 'dynamic',
                showCondition: campType === 'dynamic'
            },
            {
                name: 'performance',
                showCondition: campType === 'performance'
            },
            'region',
            'physical_region',
            {
                name: 'region_source',
                showCondition: hasEnabledFeatures('advanced_geotargeting_stat')
            },
            {
                name: 'targettype',
                showCondition: !u._.contains(['performance', 'dynamic', 'mcbanner', 'content_promotion'], campType) &&
                    !u.campaign.isCpm(campType)
            },
            {
                name: 'page',
                showCondition: campType !== 'content_promotion',
            },
            {
                name: 'ssp',
                showCondition: u.campaign.isCpm(campType) ?
                    u.consts('rights').enableCpmStatistics :
                    !u._.contains(['mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'position',
                showCondition: !u._.contains([
                    'performance',
                    'mcbanner',
                    'cpm_banner',
                    'cpm_deals',
                    'cpm_yndx_frontpage',
                    'content_promotion'
                ], campType)
            },
            {
                name: 'click_place',
                showCondition: u.campaign.isCpm(campType) ?
                    u.consts('rights').enableCpmStatistics2 :
                    !u._.contains(['performance', 'mcbanner'], campType)
            },
            {
                name: 'banner_image_type',
                showCondition: !u._.contains(['dynamic', 'mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'image_size',
                showCondition: !u._.contains(['dynamic', 'mcbanner', 'content_promotion'], campType)
            },
            {
                name: 'turbo_page_type',
                showCondition: u.consts('isTurboPageTypesInMolEnabled')
            },
            {
                name: 'device_type',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'detailed_device_type',
                showCondition: campType === 'mobile_content' ||
                    u.campaign.isCpm(campType) && u.consts('rights').enableCpmStatistics
            },
            {
                name: 'connection_type',
                showCondition: campType === 'mobile_content' ||
                    u.campaign.isCpm(campType) && u.consts('rights').enableCpmStatistics
            },
            'gender',
            'targeting_category',
            {
                name: 'prisma_income_grade',
                showCondition: u.consts('isIncomeGradeBidModifierEnabled')
            },
            'age',

            // Filters for columns
            'shows',
            {
                name: 'avg_nshow',
                showCondition: allowedAvgNShowColumns
            },
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            {
                name: 'avg_cpm',
                showCondition: u.campaign.isCpm(campType)
            },
            {
                name: 'fp_shows_avg_pos',
                showCondition: !u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage'], campType)
            },
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            {
                name: 'fp_clicks_avg_pos',
                showCondition: !u._.contains(['mcbanner', 'cpm_banner', 'cpm_deals', 'cpm_yndx_frontpage'], campType)
            },
            {
                name: 'cpm_winrate',
                showCondition: false
            },
            {
                name: 'uniq_viewers',
                showCondition: u.campaign.isCpm(campType)
            },
            {
                name: 'uniq_users_winrate',
                showCondition: false
            },
            {
                name: 'avg_view_freq',
                showCondition: u.campaign.isCpm(campType)
            },
            // https://st.yandex-team.ru/DIRECT-67514: пока убираем для mcbanner
            {
                name: 'winrate',
                showCondition: campType === 'performance'
            },
            {
                name: 'bounce_ratio',
                showCondition: campType !== 'mobile_content'
            },
            {
                name: 'pv_bounce_ratio',
                showCondition: isPostViewAvailable
            },
            {
                name: 'adepth',
                showCondition: campType !== 'mobile_content' && campType !== 'performance'
            },
            {
                name: 'pv_adepth',
                showCondition: isPostViewAvailable
            },
            {
                name: 'ab_segment',
                showCondition: showAbSegments
            },
            {
                name: 'avg_time_to_conv',
                showCondition: showAvgTimeToConversion
            },
            {
                name: 'pv_avg_time_to_conv',
                showCondition: isPostViewAvailable
            },
            'aconv',
            {
                name: 'pv_aconv',
                showCondition: isPostViewAvailable
            },
            'agoalnum',
            {
                name: 'pv_agoalnum',
                showCondition: isPostViewAvailable
            },
            'agoalcost',
            {
                name: 'pv_agoalcost',
                showCondition: isPostViewAvailable
            },
            'agoalroi',
            {
                name: 'pv_agoalroi',
                showCondition: isPostViewAvailable
            },
            {
                name: 'agoalcrr',
                showCondition: hasEnabledFeatures('crr_strategy_allowed')
            },
            {
                name: 'pv_agoalcrr',
                showCondition: isPostViewAvailable && hasEnabledFeatures('crr_strategy_allowed')
            },
            'agoalincome',
            {
                name: 'pv_agoalincome',
                showCondition: isPostViewAvailable
            },
            'agoals_profit',
            {
                name: 'pv_agoals_profit',
                showCondition: isPostViewAvailable
            },
            {
                name: 'aprgoodmultigoal',
                showCondition: !isContentPromotion
            },
            {
                name: 'pv_aprgoodmultigoal',
                showCondition: isPostViewAvailable
            },
            {
                name: 'aprgoodmultigoal_cpa',
                showCondition: !isContentPromotion
            },
            {
                name: 'pv_aprgoodmultigoal_cpa',
                showCondition: isPostViewAvailable
            },
            {
                name: 'aprgoodmultigoal_conv_rate',
                showCondition: !isContentPromotion
            },
            {
                name: 'pv_aprgoodmultigoal_conv_rate',
                showCondition: isPostViewAvailable
            },
            {
                name: 'avg_bid',
                showCondition: hasEnabledFeatures('avg_bid_in_mol')
            },
            {
                name: 'auction_win_rate', // Доля выигрышей
                showCondition: showCpmAuctionStats || showAuctionStats
            },
            {
                name: 'imp_reach_rate', // SOV
                showCondition: showCpmAuctionStats
            },
            {
                name: 'auction_wins', // Выигрыши в аукционах
                showCondition: showCpmAuctionStats
            },
            {
                name: 'auction_hits', // Участие в аукционах
                showCondition: showCpmAuctionStats
            },
            {
                name: 'served_impressions', // Число выхода рекламы для outDoor && inDoor
                showCondition: campType === 'cpm_banner'
            },
            {
                name: 'uniq_completed_viewers', // Достроенный охват для outDoor
                showCondition: campType === 'cpm_banner'
            },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_first_quartile' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_first_quartile_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_midpoint' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_midpoint_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_third_quartile' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_third_quartile_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_complete' },
            { showCondition: allowedQuartilesData || allowedVastEvents || isContentPromotionVideo, name: 'video_complete_rate' },
            {
                name: 'avg_nshow_complete',
                showCondition: allowedAvgNShowCompleteColumns
            },
            { showCondition: (allowedQuartilesData || allowedVastEvents || isContentPromotionVideo) && hasEnabledFeatures('cpv_strategies_enabled'), name: 'video_true_view' },
            { showCondition: (allowedQuartilesData || allowedVastEvents || isContentPromotionVideo) && hasEnabledFeatures('cpv_strategies_enabled'), name: 'video_avg_true_view_cost' },
            { showCondition: (allowedQuartilesData || allowedVastEvents || isContentPromotionVideo) && hasEnabledFeatures('cpv_strategies_enabled'), name: 'video_true_view_rate' },
            { showCondition: allowedQuartilesData || allowedVastEvents, name: 'video_mute' },
            { showCondition: allowedQuartilesData || allowedVastEvents, name: 'video_unmute' },
            { showCondition: allowedQuartilesData || allowedVastEvents, name: 'cpcv' },
            {
                name: 'inventory_type',
                showCondition: u.consts('rights').allowedCpmVideoBanners && u._.includes(['cpm_banner', 'cpm_price'], campType)
            },
            {
                showCondition: isContentPromotionVideo || u._.includes(['cpm_price', 'cpm_banner'], campType),
                name: 'ad_site_clicks'
            },
            { showCondition: allowedInternals, name: 'place_id' },
            { showCondition: allowedInternals, name: 'place_description' },
            { showCondition: allowedInternals, name: 'operating_system' },
            { showCondition: allowedInternals, name: 'browser' },
            { showCondition: allowedInternals, name: 'page_id' },
            { showCondition: allowedInternals, name: 'template_id' },
            { showCondition: allowedMrcVisibility, name: 'viewable_impressions_mrc' },
            { showCondition: allowedMrcVisibility, name: 'nonviewable_impressions_mrc' },
            { showCondition: allowedMrcVisibility, name: 'undetermined_impressions_mrc' },
            { showCondition: allowedMrcVisibility, name: 'measured_rate_mrc' },
            { showCondition: allowedMrcVisibility, name: 'viewable_rate_mrc' }
        ], showCondition)
    };
});
