block('i-mo-decl').mod('type', 'mol').def()(function() {
    var data = this.data,
        availableCampTypes = data.available_camp_types || [],
        hasCpmCamp = availableCampTypes.indexOf('cpm_banner') !== -1,
        hasMobileCamp = availableCampTypes.indexOf('mobile_content') !== -1,
        hasDynamicCamp = availableCampTypes.indexOf('dynamic') !== -1,
        hasDynamicMediaCamp = availableCampTypes.indexOf('performance') !== -1,
        hasCpmPriceCamp = availableCampTypes.indexOf('cpm_price') !== -1,
        hasInternalCamps = availableCampTypes.some(function(campType) {
            return u.campaign.isInternal(campType)
        }),
        hasCPMCamps = availableCampTypes.some(function(campType) {
            return u.campaign.isCpm(campType)
        }),
        hasTextCamp = availableCampTypes.indexOf('text') !== -1,
        showAbSegments = !!data.is_ab_segments_enabled,
        showAvgTimeToConversion = hasLoginRights('super_control', 'manager_control', 'support_control', 'superreader_control', 'is_superteamleader', 'is_teamleader'),
        showTrafficVolumeStat = u['traffic-volume'].showTrafficVolumeStatFieldsMO(availableCampTypes),
        allowedInternals = u.consts('rights').enableInternalCampaigns && hasInternalCamps,
        multiClientsModeEnabled = u.consts('rights').enableStatsMultiClientsMode,
        allowedContentTargeting = hasTextCamp && hasEnabledFeatures('content_category_targeting_cpc') || hasCpmCamp || hasCpmPriceCamp,
        showCpmAuctionStats = hasEnabledFeatures('enable_auction_fields_in_mol') && hasCpmCamp,
        isPostViewAvailable = hasCPMCamps && hasEnabledFeatures('post_view_statistics'),
        showCondition = function(item) {
            return typeof item === 'string' || (item.hasOwnProperty('showCondition') ? item.showCondition : true);
        };

    return {
        columns: u._.filter([
            'shows',
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            {
                name: 'avg_cpm',
                showCondition: u.consts('rights').enableCpmStatistics
            },
            'fp_shows_avg_pos',
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            'fp_clicks_avg_pos',
            {
                name: 'cpm_winrate',
                showCondition: false
            },
            {
                name: 'uniq_viewers',
                showCondition: u.consts('rights').enableCpmStatistics,
                disable: [
                    'tags', 'contextcond_orig', 'contexttype_orig', 'criterion_type', 'match_type', 'retargeting_coef',
                    'page_group', 'page', 'physical_region', 'banner_image_type', 'image_size', 'content_targeting'
                ]
            },
            {
                name: 'uniq_users_winrate',
                showCondition: false
            },
            {
                name: 'avg_view_freq',
                showCondition: u.consts('rights').enableCpmStatistics,
                disable: [
                    'tags', 'contextcond_orig', 'contexttype_orig', 'criterion_type', 'match_type', 'retargeting_coef',
                    'page_group', 'page', 'physical_region', 'banner_image_type', 'image_size', 'content_targeting'
                ]
            },
            {
                name: 'winrate',
                lock: ['campaign'],
                showCondition: !allowedInternals,
                disable: [
                    'tags',
                    'banner',
                    'gender',
                    'age',
                    'connection_type',
                    'detailed_device_type',
                    'banner_type',
                    'image_size',
                    'banner_image_type',
                    'retargeting_coef'
                ]
            },
            'bounce_ratio',
            'adepth',
            {
                name: 'avg_time_to_conv',
                showCondition: showAvgTimeToConversion
            },
            'aconv',
            'agoalcost',
            'agoalnum',
            'agoalroi',
            {
                name: 'agoalcrr',
                showCondition: hasEnabledFeatures('crr_strategy_allowed')
            },
            'agoalincome',
            'agoals_profit',
            'aprgoodmultigoal',
            'aprgoodmultigoal_cpa',
            'aprgoodmultigoal_conv_rate',
            {
                name: 'avg_bid',
                showCondition: hasEnabledFeatures('avg_bid_in_mol')
            },
            {
                name: 'auction_win_rate', // Доля выигрышей
                showCondition: showCpmAuctionStats,
                disable: [
                    'tags', 'adgroup', 'banner', 'banner_type', 'contextcond_orig', 'retargeting_coef',
                    'targettype', 'page_group', 'page', 'deal', 'ssp', 'physical_region', 'position',
                    'click_place', 'banner_image_type', 'image_size', 'turbo_page_type', 'detailed_device_type',
                    'connection_type', 'gender', 'targeting_category', 'age', 'contexttype_orig', 'criterion_type',
                    'match_type', 'inventory_type', 'place_id', 'place_description', 'operating_system', 'browser',
                    'page_id', 'content_targeting'
                ]
            },

            // @skywhale временно скрываем видео статистику
            // https://st.yandex-team.ru/DIRECT-81886#5c756685195db5001e93a965
            // { showCondition: allowedVastEvents, name: 'video_mute' },
            // { showCondition: allowedVastEvents, name: 'video_unmute' },

            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_first_quartile' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_midpoint' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_third_quartile' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_complete' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_first_quartile_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_midpoint_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_third_quartile_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_complete_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'cpcv' },
            { showCondition: u.consts('rights').enableCpmStatistics2, name: 'ad_site_clicks' },

            { showCondition: allowedInternals, name: 'close_clicks' },
            { showCondition: allowedInternals, name: 'close_ctr' },

            { showCondition: u.consts('rights').enableCpmStatistics, name: 'viewable_impressions_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'nonviewable_impressions_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'undetermined_impressions_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'measured_rate_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'viewable_rate_mrc' }
        ], showCondition),
        slices: u._.filter([
            {
                name: 'client_login',
                showCondition: u.consts('rights').enableMcc,
            },
            'campaign_type',
            'campaign',
            'tags',
            'adgroup',
            'banner',
            'contexttype_orig',
            'match_type',
            {
                name: 'inventory_type',
                showCondition: u.consts('rights').enableCpmStatistics,
                disable: [
                    'aprgoodmultigoal', 'aprgoodmultigoal_cpa', 'aprgoodmultigoal_conv_rate', 'avg_time_to_conv'
                ]
            },
            {
                name: 'banner_type',
                disable: ['winrate']
            },
            {
                name: 'contextcond_orig',
                disable: ['page_group', 'page']
            },
            {
                name: 'retargeting_coef',
                disable: ['page_group', 'page', 'winrate']
            },
            'targettype',
            {
                name: 'page_group',
                disable: ['page', 'retargeting_coef', 'contextcond_orig', 'content_targeting'],
                lock: ['targettype']
            },
            {
                name: 'page',
                showCondition: hasLoginRights('super_control', 'superreader_control', 'support_control'),
                disable: ['page_group', 'retargeting_coef', 'contextcond_orig', 'content_targeting'],
                lock: ['targettype']
            },
            {
                name: 'deal',
                showCondition: hasLoginRights('super_control')
            },
            {
                name: 'ssp',
                showCondition: hasTextCamp || hasMobileCamp
            },
            'region',
            'physical_region',
            {
                name: 'region_source',
                showCondition: hasEnabledFeatures('advanced_geotargeting_stat')
            },
            'position',
            {
                name: 'click_place',
                disable: [
                    'shows', 'eshows', 'ctr', 'ectr', 'fp_shows_avg_pos', 'avg_x', 'uniq_viewers', 'avg_view_freq',
                    'video_first_quartile', 'video_midpoint', 'video_midpoint_rate', 'video_complete',
                    'video_first_quartile_rate', 'video_midpoint_rate', 'video_third_quartile',
                    'video_third_quartile_rate', 'video_complete_rate', 'avg_cpm', 'cpcv', 'ad_site_clicks',
                    'viewable_impressions_mrc', 'nonviewable_impressions_mrc', 'undetermined_impressions_mrc',
                    'measured_rate_mrc', 'viewable_rate_mrc'
                ]
            },
            'banner_image_type',
            'image_size',
            {
                name: 'turbo_page_type',
                showCondition: u.consts('isTurboPageTypesInMolEnabled')
            },
            'device_type',
            {
                name: 'detailed_device_type',
                showCondition: hasMobileCamp
            },
            {
                name: 'connection_type',
                showCondition: hasMobileCamp
            },
            'gender',
            'targeting_category',
            {
                name: 'prisma_income_grade',
                showCondition: u.consts('isIncomeGradeBidModifierEnabled')
            },
            'age',
            { showCondition: allowedInternals && multiClientsModeEnabled, name: 'internal_product_name' },
            { showCondition: !allowedInternals && multiClientsModeEnabled, name: 'client_id' },
            { showCondition: allowedInternals, name: 'place_id' },
            { showCondition: allowedInternals, name: 'place_description' },
            { showCondition: allowedInternals, name: 'operating_system' },
            { showCondition: allowedInternals, name: 'browser' },
            { showCondition: allowedInternals, name: 'page_id' },
            {
                name: 'content_targeting',
                showCondition: allowedContentTargeting,
                disable: ['page', 'page_group', 'eshows', 'avg_bid', 'fp_shows_avg_pos', 'avg_x', 'fp_clicks_avg_pos']
            }
        ], showCondition),
        filters: u._.filter([
            'campaign_type',
            'campaign',
            'campaign_strategy',
            'campaign_status',
            'tags',
            'adgroup_id',
            'adgroup',
            'adgroup_status',
            'banner',
            'banner_status',
            'banner_type',
            'contexttype_orig',
            'match_type',
            'phrase_orig',
            'retargeting',
            {
                name: 'deal_export_id',
                showCondition: hasLoginRights('super_control')
            },
            {
                name: 'rmp_interest',
                showCondition: hasMobileCamp
            },
            'retargeting_coef',
            {
                name: 'dynamic',
                showCondition: hasDynamicCamp
            },
            {
                name: 'performance',
                showCondition: hasDynamicMediaCamp
            },
            'region',
            'physical_region',
            'targettype',
            {
                name: 'region_source',
                showCondition: hasEnabledFeatures('advanced_geotargeting_stat')
            },
            'page',
            {
                name: 'ssp',
                showCondition: hasTextCamp || hasMobileCamp
            },
            'position',
            'click_place',
            'banner_image_type',
            'image_size',
            {
                name: 'turbo_page_type',
                showCondition: u.consts('isTurboPageTypesInMolEnabled')
            },
            'device_type',
            {
                name: 'detailed_device_type',
                showCondition: hasMobileCamp
            },
            {
                name: 'connection_type',
                showCondition: hasMobileCamp
            },
            'gender',
            'targeting_category',
            {
                name: 'prisma_income_grade',
                showCondition: u.consts('isIncomeGradeBidModifierEnabled')
            },
            'age',

            // Filters for columns
            'shows',
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            {
                name: 'avg_cpm',
                showCondition: u.consts('rights').enableCpmStatistics
            },
            'fp_shows_avg_pos',
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            'fp_clicks_avg_pos',
            {
                name: 'cpm_winrate',
                showCondition: false
            },
            {
                name: 'uniq_viewers',
                showCondition: u.consts('rights').enableCpmStatistics
            },
            {
                name: 'uniq_users_winrate',
                showCondition: false
            },
            {
                name: 'avg_view_freq',
                showCondition: u.consts('rights').enableCpmStatistics
            },
            'winrate',
            {
                name: 'ab_segment',
                showCondition: showAbSegments
            },
            {
                name: 'avg_time_to_conv',
                showCondition: showAvgTimeToConversion
            },
            'bounce_ratio',
            {
                name: 'pv_bounce_ratio',
                showCondition: isPostViewAvailable
            },
            'adepth',
            {
                name: 'pv_adepth',
                showCondition: isPostViewAvailable
            },
            'aconv',
            {
                name: 'pv_aconv',
                showCondition: isPostViewAvailable
            },
            'agoalnum',
            {
                name: 'pv_agoalnum',
                showCondition: isPostViewAvailable
            },
            'agoalcost',
            {
                name: 'pv_agoalcost',
                showCondition: isPostViewAvailable
            },
            'agoalroi',
            {
                name: 'pv_agoalroi',
                showCondition: isPostViewAvailable
            },
            {
                name: 'agoalcrr',
                showCondition: hasEnabledFeatures('crr_strategy_allowed')
            },
            'agoalincome',
            {
                name: 'pv_agoalincome',
                showCondition: isPostViewAvailable
            },
            'agoals_profit',
            {
                name: 'pv_agoals_profit',
                showCondition: isPostViewAvailable
            },
            'aprgoodmultigoal',
            {
                name: 'pv_aprgoodmultigoal',
                showCondition: isPostViewAvailable
            },
            'aprgoodmultigoal_cpa',
            {
                name: 'pv_aprgoodmultigoal_cpa',
                showCondition: isPostViewAvailable
            },
            'aprgoodmultigoal_conv_rate',
            {
                name: 'pv_aprgoodmultigoal_conv_rate',
                showCondition: isPostViewAvailable
            },
            {
                name: 'avg_bid',
                showCondition: hasEnabledFeatures('avg_bid_in_mol')
            },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_first_quartile' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_midpoint' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_third_quartile' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_complete' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_first_quartile_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_midpoint_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_third_quartile_rate' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'video_complete_rate' },
            // { showCondition: allowedVastEvents, name: 'video_mute' },
            // { showCondition: allowedVastEvents, name: 'video_unmute' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'cpcv' },
            { showCondition: u.consts('rights').enableCpmStatistics2, name: 'ad_site_clicks' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'inventory_type' },
            { showCondition: allowedInternals && multiClientsModeEnabled, name: 'internal_product_name' },
            { showCondition: !allowedInternals && multiClientsModeEnabled, name: 'client_id' },
            { showCondition: allowedInternals, name: 'place_id' },
            { showCondition: allowedInternals, name: 'place_description' },
            { showCondition: allowedInternals, name: 'operating_system' },
            { showCondition: allowedInternals, name: 'browser' },
            { showCondition: allowedInternals, name: 'page_id' },
            { showCondition: allowedInternals, name: 'template_id' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'viewable_impressions_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'nonviewable_impressions_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'undetermined_impressions_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'measured_rate_mrc' },
            { showCondition: u.consts('rights').enableCpmStatistics, name: 'viewable_rate_mrc' }
        ], showCondition)
    };
});
