block('i-mo-decl').mod('type', 'search-queries').def()(function() {
    var data = this.data,
        availableCampTypes = data.available_camp_types || [],
        hasDynamicCamp = availableCampTypes.indexOf('dynamic') !== -1,
        isMultipleCampaigns = !this.data.FORM.single_camp,
        campType = (data.campaign || {}).type,
        showTrafficVolumeStat = u['traffic-volume'].showTrafficVolumeStatFieldsMO(isMultipleCampaigns ? availableCampTypes : campType),
        showCondition = function(item) {
            return typeof item === 'string' || (item.hasOwnProperty('showCondition') ? item.showCondition : true);
        };

    return {
        columns: u._.filter([
            'shows',
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            {
                name: 'fp_shows_avg_pos',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            {
                name: 'fp_clicks_avg_pos',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'bounce_ratio',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            {
                name: 'adepth',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            'aconv',
            'agoalcost',
            'agoalnum',
            'agoalroi',
            {
                name: 'agoalcrr',
                showCondition: hasEnabledFeatures('crr_strategy_allowed')
            },
            'agoalincome'//,
            // https://st.yandex-team.ru/DIRECT-67514: пока убираем для mcbanner
            // {
            //     name: 'winrate',
            //     showCondition: campType === 'mcbanner',
            //     disable: ['banner']
            // }
            // https://st.yandex-team.ru/DIRECT-67514: пока убираем для mcbanner
            //{
            //    name: 'winrate',
            //    showCondition: campType === 'mcbanner',
            //    disable: ['banner']
            //}
        ], showCondition),
        slices: u._.filter([
            {
                name: 'client_login',
                showCondition: u.consts('rights').enableMcc,
            },
            {
                name: 'search_query',
                lock: ['search_query']
            },
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // 'search_query_status',
            {
                name: 'campaign_type',
                showCondition: isMultipleCampaigns
            },
            {
                name: 'campaign',
                showCondition: isMultipleCampaigns
            },
            'adgroup',
            'banner',
            {
                name: 'contexttype_orig',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'matched_phrase',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'match_type',
                showCondition: campType !== 'mcbanner'
            },
            'contextcond_orig',
            {
                name: 'page_group',
                disable: ['page'],
                lock: ['targettype']
            },
            {
                name: 'page',
                showCondition: hasLoginRights('super_control', 'superreader_control', 'support_control'),
                disable: ['page_group'],
                lock: ['targettype']
            },
            // {
            //     name: 'ext_phrase_status',
            //     lock: [
            //         'contexttype_orig',
            //         'contextcond_orig'
            //     ],
            //     showCondition: u.consts('rights').canSeeStatisticPhrasesStatus
            // },
            {
                name: 'sim_distance',
                showCondition: hasLoginRights('super_control', 'superreader_control', 'support_control') && campType !== 'mcbanner'
            },
            'targeting_category',
            {
                name: 'prisma_income_grade',
                showCondition: u.consts('isIncomeGradeBidModifierEnabled')
            }
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // {
            //     name: 'ext_phrase_status',
            //     lock: [
            //         'contexttype',
            //         'contextcond_ext'
            //     ]
            // }
        ], showCondition),
        filters: u._.filter([
            {
                name: 'campaign_type',
                showCondition: isMultipleCampaigns
            },
            {
                name: 'campaign',
                showCondition: isMultipleCampaigns
            },
            'adgroup',
            'banner',
            'search_query',
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // 'search_query_status',
            {
                name: 'contexttype_orig',
                showCondition: isMultipleCampaigns ||
                    (campType !== 'dynamic' && campType !== 'performance' && campType !== 'mcbanner')
            },
            // DIRECT-65239 - статусы выпиливаем не окончательно, пока что-просто скрываем
            // {
            //     name: 'ext_phrase_status',
            //     showCondition: (isMultipleCampaigns || (campType !== 'dynamic' && campType !== 'performance'))
            // },
            {
                name: 'phrase_orig',
                showCondition: isMultipleCampaigns || campType !== 'dynamic'
            },
            {
                name: 'dynamic',
                showCondition: isMultipleCampaigns ? hasDynamicCamp : campType === 'dynamic'
            },
            'targeting_category',
            {
                name: 'prisma_income_grade',
                showCondition: u.consts('isIncomeGradeBidModifierEnabled')
            },
            'goal_id',
            'page',

            // Filters for columns
            'shows',
            {
                name: 'eshows',
                showCondition: showTrafficVolumeStat
            },
            'clicks',
            'ctr',
            {
                name: 'ectr',
                showCondition: showTrafficVolumeStat
            },
            'sum',
            'av_sum',
            {
                name: 'fp_shows_avg_pos',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'avg_x',
                showCondition: showTrafficVolumeStat
            },
            {
                name: 'fp_clicks_avg_pos',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'matched_phrase',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'match_type',
                showCondition: campType !== 'mcbanner'
            },
            {
                name: 'bounce_ratio',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            {
                name: 'adepth',
                showCondition: isMultipleCampaigns || (campType !== 'mobile_content' && campType !== 'performance')
            },
            'aconv',
            'agoalnum',
            'agoalcost',
            'agoalroi',
            {
                name: 'agoalcrr',
                showCondition: hasEnabledFeatures('crr_strategy_allowed')
            },
            'agoalincome',
            {
                name: 'sim_distance',
                showCondition: hasLoginRights('super_control', 'superreader_control', 'support_control') &&
                    (isMultipleCampaigns || (campType !== 'performance' && campType !== 'mcbanner'))
            }
        ], showCondition)
    };
});
