(function($) {
    var formatter = BEM.blocks['i-utils'].numberFormatter;

    /**
     *  Математика переноса средств между кампаниями
     */
    BEM.DOM.decl('i-money-transfer', {}, {
        /**
         * Распределяет сумму sum по равномерно по числу кампаний campsNum
         * @param {Number} sum - сумма которую необходимо распределить
         * @param {Number} count - число кампаний
         * @returns {Object}
         */
        equalToCamps: function(sum, count) {
            var value = formatter.round(sum / count, { roundType: 'floor' }),
                remains = {
                    num: Math.round((sum - value * count) * 100),
                    value: 0.01
                };

            return { value: value, remains: remains };
        },

        /**
         *
         * Распределяет текущую сумму пропорционально расходам на кампании
         * @param {Number} sum - сумма, которую нужно распределить
         * @param {Object} outlayArray -  массив с данными по расходам на кампаниях
         * @return {Object}
         */
        proportionToCamps: function(sum, outlayArray) {
            var result = [],
                total = 0,
                adjust = 0,
                length = 0;

            $.each(outlayArray, function(cid, value) {
                total += value;
                !!value && length++;
            });

            $.each(outlayArray, function(i, value) {
                if (value == 0) return;

                var prop = total == 0 ? 1 / length : value / total,
                    res = formatter.round(sum * prop, { roundType: 'floor' });
                result.push(res);
                adjust += res;
            });

            var remains = {
                num: Math.round((sum - adjust) * 100),
                value: 0.01
            };

            return { value: result, remains: remains };
        }
    });

})(jQuery);
