describe('i-oferta', function() {
    var oferta = u['i-oferta'];

    describe('Проверка на домене ru', function() {
        before(function() {
            sinon.stub(u, 'consts').callsFake(function(name) {
                return {
                    domains: { ru: true },
                    SCRIPT: 'https://direct.yandex.ru',
                    SCRIPT_OBJECT: { host: 'direct.yandex.ru'}
                }[name];
            });
        });

        after(function() {
            u.consts.restore();
        });

        describe('Работа функции u.getOfertaUrl если передан firmId', function() {
            [
                { firmId: 1, name: 'ООО Яндекс', result: 'https://direct.yandex.ru/doccenter/legal/oferta_direct/index.xml' },
                { firmId: 2, name: 'ООО Яндекс.Украин', result: 'https://direct.yandex.ua/doccenter/legal/oferta_direct/index.xml' },
                { firmId: 3, name: 'КазНет Медиа', result: 'https://direct.yandex.ru/doccenter/legal/oferta_direct/index.xml' },
                { firmId: 4, name: 'Yandex Inc', result: 'https://direct.yandex.com/doccenter/legal/inc_terms_and_conditions/index.xml' },
                { firmId: 7, name: 'Yandex Europe AG', result: 'https://direct.yandex.com/doccenter/legal/oferta_direct_ch/index.xml' },
                { firmId: 8, name: 'Yandex Turkey', result: 'https://direct.yandex.com.tr/doccenter/legal/oferta_direct/index.xml' }
            ].forEach(function(block) {
                it(block.name + ' (firmId = ' + block.firmId + '): ' + block.result, function() {
                    expect(oferta.getOfertaUrl({
                        firmId: block.firmId,
                        source: 'oferta_direct'
                    })).to.equal(block.result);
                });
            });
        });

        describe('Корректно подставляется source', function() {
            [
                { source: 'oferta_direct', path: 'https://direct.yandex.ru/doccenter/legal/oferta_direct/index.xml' },
                { source: 'direct_api', path: 'https://direct.yandex.ru/doccenter/legal/direct_api/index.xml' },
                { source: 'direct_api_developers', path: 'https://direct.yandex.ru/doccenter/legal/direct_api_developers/index.xml' },
            ].forEach(function(block) {
                it('source: ' + block.source, function() {
                    expect(oferta.getOfertaUrl({
                        source: block.source
                    })).to.equal(block.path);
                });
            });

        });

        it('Корректно подставляются в ссылку параметры из query', function() {
            expect(oferta.getOfertaUrl({
                source: 'oferta_direct',
                query: {
                    bla1: 1,
                    bla2: 2
                }
            })).to.equal('https://direct.yandex.ru/doccenter/legal/oferta_direct/index.xml?bla1=1&bla2=2');
        });
    });

    describe('Проверка на турецком домене', function() {
        before(function() {
            sinon.stub(u, 'consts').callsFake(function(name) {
                return {
                    domains: { tr: true },
                    SCRIPT: 'https://direct.yandex.com.tr',
                    SCRIPT_OBJECT: { host: 'direct.yandex.com.tr'}
                }[name];
            });
        });

        after(function() {
            u.consts.restore();
        });

        it('Корректно подставляется параметр lang в ссылку на турецкую оферту', function() {
            expect(oferta.getOfertaUrl({
                source: 'oferta_direct'
            })).to.equal('https://direct.yandex.com.tr/doccenter/legal/oferta_direct/index.xml?lang=tr');
        });

        it('Турецкая оферта API берется с домена ru', function() {
            expect(oferta.getOfertaUrl({
                source: 'direct_api'
            })).to.equal('https://direct.yandex.ru/doccenter/legal/direct_api/index.xml?lang=en');
        });
    });

    describe('Проверка на .com', function() {
        before(function() {
            sinon.stub(u, 'consts').callsFake(function(name) {
                return {
                    domains: { com: true },
                    SCRIPT: 'https://direct.yandex.com',
                    SCRIPT_OBJECT: { host: 'direct.yandex.com'}
                }[name];
            });
        });

        after(function() {
            u.consts.restore();
        });

        it('На домене com оферта API берется с домена ru', function() {
            expect(oferta.getOfertaUrl({
                source: 'direct_api'
            })).to.equal('https://direct.yandex.ru/doccenter/legal/direct_api/index.xml?lang=en');
        });
    });

});
