(function() {
    /**
     * Вычисляет ссылку на оферту
     * @param {String|'direct_api'|'direct_api_developers'|'oferta_direct'} path
     * @param {String|'ru'|'ua'|'kz'|'com'|'com.tr'} [domain]
     * @returns {String}
     */
    function _calcOfertaUrl(path, domain) {
        var host = u.consts('SCRIPT_OBJECT').host;

        //если нужно отправить на оферту на другой домен, подменяем домен в урле
        if (domain) {
            host = host.replace(/ru|com.tr|com|ua|kz|by/, domain);
        }

        return {
            protocol: 'https',
            host: host,
            path: '/doccenter/legal/' + path + '/index.xml'
        }
    }

    /**
    * Вычисляет ссылку на оферту по firmId
    * @param {String} firmId
    * @returns {String}
    */
    function _calcOfertaUrlByFirmId(firmId) {
        return ({
            //ООО Яндекс
            1: _calcOfertaUrl('oferta_direct', 'ru'),
            //ООО Яндекс.Украина
            2: _calcOfertaUrl('oferta_direct', 'ua'),
            //КазНет Медиа
            3: _calcOfertaUrl('oferta_direct', 'ru'),
            //Yandex Inc
            4: _calcOfertaUrl('inc_terms_and_conditions', 'com'),
            // Yandex Europe AG
            7: _calcOfertaUrl('oferta_direct_ch', 'com'),
            // Yandex Turkey
            8: _calcOfertaUrl('oferta_direct', 'com.tr')
        })[firmId];
    }

    u.register({

        'i-oferta': {
            /**
             *
             * @param {Object} params
             * @param {'oferta_direct'|'direct_api'|'direct_api_developers'} params.source
             * @param {Object} params.query
             * @param {String} params.firmId
             * @returns {String}
             */
            getOfertaUrl: function(params) {
                params = params || {};

                var url,
                    domain;

                if (params.source == 'oferta_direct') {
                    url = _calcOfertaUrlByFirmId(params.firmId);
                    //для DIRECT-53240
                    if (params.yandexDomain == 'yandex.by')
                        url = _calcOfertaUrl('oferta_direct', 'by');
                }

                if (!url) {
                    [{
                        domain: 'tr',
                        lang: params.source == 'oferta_direct' ? 'tr' : 'en'
                    }, { domain: 'com', lang: 'en' }].forEach(function(langHash) {
                        if (u.consts('domains')[langHash.domain]) {
                            params.query = params.query || {};
                            params.query.lang = langHash.lang;
                            //оферту для турецкого и английского API берем с домена ru
                            if (params.source !== 'oferta_direct' ) domain = 'ru';
                        }
                    });

                    url = _calcOfertaUrl(params.source, domain);

                }
                return u.formatUrl(u._.extend(url, {
                    query: u._.isEmpty(params.query) ? null : params.query
                }));
            }
        }

    });
}());
