block('i-office-contacts').mod('type', 'morda')(

    def()(function() {
        return apply('data');
    }),

    mode('data')(function() {
        var supportPhone = this.data.another_phone_for_main_page == 1 ? '+7 (499) 719-73-26' : '+7 (495) 739-37-77';
        var countries = {
                ru: {
                    phone: '8 800 234-24-80',
                    comment: iget2(
                        'i-office-contacts',
                        'otdel-klientskogo-servisa-zvonok',
                        'отдел клиентского сервиса, звонок из регионов России бесплатный'
                    ),
                    supportComment: iget2('i-office-contacts', 'zvonok-iz-regionov-rossii', 'звонок из регионов России бесплатный')
                },
                //Беларусь
                blr: {
                    phone: '+375 (17) 336-31-36',
                    comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                },
                kaz: {
                    phone: supportPhone,
                    comment: iget2('i-office-contacts', 'telefon-v-moskve', 'телефон в Москве')
                },
                ua: {
                    phone: '0 800 60-48-61',
                    add: '2890',
                    comment: iget2(
                        'i-office-contacts',
                        'sluzhba-podderzhki-zvonok-so',
                        'служба поддержки, звонок со стационарных телефонов Украины бесплатный'
                    ),
                    supportComment: iget2('i-office-contacts', 'zvonok-so-stacionarnyh-telefonov', 'звонок со стационарных телефонов Украины бесплатный')
                },
                //Страны СНГ кроме Беларусии и Укранины
                cis: {
                    phone: '8 800 234-24-80',
                    comment: iget2('i-office-contacts', 'zvonok-iz-stran-sng', 'звонок из стран СНГ бесплатный')
                },
                other: {
                    phone: '8 800 234-24-80',
                    comment: iget2('i-office-contacts', 'zvonok-iz-regionov-rossii', 'звонок из регионов России бесплатный')
                }
            },
            customerServices = {
                msk: {
                    phone: supportPhone,
                    comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00'),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00', 'ежедневно с 5:00 до 24:00')
                },
                spb: {
                    phone: '+7 (812) 633-36-00',
                    add: '2480',
                    comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00'),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00', 'ежедневно с 5:00 до 24:00')
                },
                ekb: {
                    phone: '+7 (343) 385-01-00',
                    add: '2480',
                    comment: iget2(
                        'i-office-contacts',
                        'otdel-klientskogo-servisa-s-101',
                        'отдел клиентского сервиса, с 5:00 до 24:00 по московскому времени'
                    ),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00-102', 'ежедневно с 5:00 до 24:00 по московскому времени')
                },
                nsk: {
                    phone: '+7 (383) 230-43-06',
                    add: '2480',
                    comment: iget2(
                        'i-office-contacts',
                        'otdel-klientskogo-servisa-s-101',
                        'отдел клиентского сервиса, с 5:00 до 24:00 по московскому времени'
                    ),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00-102', 'ежедневно с 5:00 до 24:00 по московскому времени')
                },
                kazan: {
                    phone: '+7 (843) 524-71-71',
                    add: '2480',
                    comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00'),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00', 'ежедневно с 5:00 до 24:00')
                },
                rostov: {
                    phone: '+7 (863) 268-83-00',
                    add: '2480',
                    comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00'),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00', 'ежедневно с 5:00 до 24:00')
                },
                nnovgorod: {
                    phone: '+7 (831) 233-06-06',
                    add: '2480',
                    comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00'),
                    supportComment: iget2('i-office-contacts', 'ezhednevno-s-5-00', 'ежедневно с 5:00 до 24:00')
                },
                blr: {
                    phone: '+7 (863) 268-83-00',
                    add: '2480',
                    comment: iget2('i-office-contacts', 'telefon-v-rostove-na', 'телефон в Ростове-На-Дону')
                },
                other: {
                    phone: supportPhone,
                    comment: iget2('i-office-contacts', 'telefon-v-moskve', 'телефон в Москве')
                }
            };

        return {
            en: {
                client: [{
                    phone: '+7 (495) 739-70-00',
                    add: '1247',
                    comment: iget2('i-office-contacts', 'otdel-po-rabote-s', 'отдел по работе с клиентами, с 10:00 до 19:00')
                }],
                support: [
                    {
                        phone: '+7 (495) 780-65-20',
                        comment: iget2(
                            'i-office-contacts',
                            'sluzhba-podderzhki-ezhednevno-s',
                            'служба поддержки, ежедневно с 10:00 до 20:00 по московскому времени'
                        ),
                        supportComment: iget2('i-office-contacts', 'ezhednevno-s-10-00', 'ежедневно с 10:00 до 20:00 по московскому времени')
                    },
                    {
                        phone: '8 800 250-9639',
                        add: '2482',
                        comment: countries.ru.comment
                    }
                ],
                email: 'eng-ad@yandex-team.ru'
            },
            msk: {
                support: [
                    customerServices.msk,
                    countries.ru
                ],
                email: 'adv@yandex-team.ru'
            },
            spb: {
                support: [
                    customerServices.spb,
                    countries.ru
                ],
                email: 'spbsales@yandex-team.ru'
            },
            ekb: {
                support: [
                    customerServices.ekb,
                    countries.ru
                ],
                email: 'uralsales@yandex-team.ru'
            },
            kazan: {
                support: [
                    customerServices.kazan,
                    countries.ru
                ],
                email: 'kzn-sales@yandex-team.ru'
            },
            rostov: {
                support: [
                    customerServices.rostov,
                    countries.ru
                ],
                email: 'rndsales@yandex-team.ru'
            },
            nnovgorod: {
                support: [
                    customerServices.nnovgorod,
                    countries.ru
                ]
            },
            nsk: {
                support: [
                    customerServices.nsk,
                    countries.ru
                ],
                email: 'sales-nsk@yandex-team.ru'
            },
            kiev: {
                client: [
                    {
                        phone: supportPhone,
                        comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-po', 'отдел клиентского сервиса, по будням с 5:00 до 24:00')
                    }
                ],
                email: 'kiev-sales@yandex-team.com.ua',
                supportMorda: [
                    {
                        phone: supportPhone,
                        comment: iget2('i-office-contacts', 'po-budnyam-s-5', 'По будням с 5:00 до 24:00')
                    }
                ]
            },
            ukr: {
                client: [
                    {
                        phone: supportPhone,
                        comment: iget2('i-office-contacts', 'otdel-klientskogo-servisa-po', 'отдел клиентского сервиса, по будням с 5:00 до 24:00')
                    }
                ],
                //Для Украины телефон саппорта для морды отличается от телефона саппорта в остальных местах
                //Историю странных взаимоотношений с Украиной читать здесь DIRECT-52723
                supportMorda: [
                    {
                        phone: supportPhone,
                        comment: iget2('i-office-contacts', 'po-budnyam-s-9', 'По будням с 9:00 до 21:00')
                    }
                ],
                email: 'adv@yandex-team.com.ua'
            },
            kaz: {
                support: [
                    customerServices.msk,
                    countries.kaz
                ],
                supportMorda: [
                    {
                        phone: '+7 (727) 313-28-05',
                        comment: iget2('i-office-contacts', 'po-budnyam-s-10-do-19', 'По будням с 10:00 до 19:00')
                    }
                ],
            },
            tr: {
                support: [{
                    email: 'destek@direct.yandex.com.tr'
                }]
            },
            blr: {
                support: [
                    customerServices.blr,
                    countries.blr
                ],
                supportMorda: [
                    countries.blr
                ]
            },
            /* показываем обычный номер */
            other: {
                support: [
                    customerServices.other,
                    countries.other
                ]
            }
        };
    })
);
