block('i-office-contacts')(

    def()(function() {
        return apply('data');
    }),

    //@see b-office-contacts
    mode('data')(function() {
        var supportPhone = this.data.index_page == 1 && this.data.another_phone_for_main_page == 1 ?
            '+7 (499) 719-73-26' :
            '+7 (495) 739-37-77';
        var countries = {
                ru: '8 800 234-24-80',
                ua: '0 800 21-41-48'
            },
            regional = {
                ru: [
                    '8 800 234-24-80',
                    0,
                    iget2(
                        'i-office-contacts',
                        'otdel-klientskogo-servisa-zvonok',
                        'отдел клиентского сервиса, звонок из регионов России бесплатный'
                    )
                ],
                cis: [
                    '8 800 234-24-80',
                    0,
                    iget2('i-office-contacts', 'zvonok-iz-stran-sng', 'звонок из стран СНГ бесплатный')
                ],
                blr: [
                    '+375 17 336-31-36',
                    0,
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                ],
                blrAdditional: [
                    '8 820 00-73-00-52',
                    0,
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-zvonok-belarus', 'отдел клиентского сервиса, с 5:00 до 24:00, звонок из Беларуси бесплатный')
                ],
                kaz: [
                    supportPhone,
                    0,
                    iget2('i-office-contacts', 'telefon-v-moskve', 'телефон в Москве')
                ],
                other: [
                    '8 800 234-24-80',
                    0,
                    iget2('i-office-contacts', 'zvonok-iz-regionov-rossii', 'звонок из регионов России бесплатный')
                ]
            },
            customerServices = {
                msk: [
                    supportPhone,
                    0,
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                ],
                spb: [
                    '+7 (812) 633-36-00',
                    '2480',
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                ],
                ekb: [
                    '+7 (343) 385-01-00',
                    '2480',
                    iget2(
                        'i-office-contacts',
                        'otdel-klientskogo-servisa-s-101',
                        'отдел клиентского сервиса, с 5:00 до 24:00 по московскому времени'
                    )
                ],
                nsk: [
                    '+7 (383) 230-43-06',
                    '2480',
                    iget2(
                        'i-office-contacts',
                        'otdel-klientskogo-servisa-s-101',
                        'отдел клиентского сервиса, с 5:00 до 24:00 по московскому времени'
                    )
                ],
                kazan: [
                    '+7 (843) 524-71-71',
                    '2480',
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                ],
                rostov: [
                    '+7 (863) 268-83-00',
                    '2480',
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                ],
                nnovgorod: [
                    '+7 (831) 233-06-06',
                    '2480',
                    iget2('i-office-contacts', 'otdel-klientskogo-servisa-s-100', 'отдел клиентского сервиса, с 5:00 до 24:00')
                ],
                other: [
                    supportPhone,
                    0,
                    iget2('i-office-contacts', 'telefon-v-moskve', 'телефон в Москве')
                ],
                blr: [
                    supportPhone,
                    0
                ],
                kaz: [
                    '+7 (727) 313-28-05',
                    0,
                    iget2('i-office-contacts', 'otdel-po-rabote-s-budni', 'отдел по работе с клиентами, по будням с 10:00 до 19:00')
                ],
            };

        return {
            countries: countries,
            offices: {
                en: {
                    support: {
                        landline: [
                            ['+7 (495) 780-65-20', 0, iget2('i-office-contacts', 'support-service-call-on', 'support service, call on weekdays from 10:00 to 20:00 Moscow time')]
                        ],
                        regional: [
                            ['8 800 250-96-39', '2482', 'support service, toll-free from Russian regions']
                        ]
                    },
                    email: 'eng-ad@yandex-team.ru'
                },
                msk: {
                    support: {
                        landline: [customerServices.msk],
                        regional: [regional.ru]
                    },
                    email: 'adv@yandex-team.ru'
                },
                spb: {
                    support: {
                        landline: [customerServices.spb],
                        regional: [regional.ru]
                    },
                    email: 'spbsales@yandex-team.ru'
                },
                ekb: {
                    support: {
                        landline: [customerServices.ekb],
                        regional: [regional.ru]
                    },
                    email: 'uralsales@yandex-team.ru'
                },
                kazan: {
                    support: {
                        landline: [customerServices.kazan],
                        regional: [regional.ru]
                    },
                    email: 'kzn-sales@yandex-team.ru'
                },
                rostov: {
                    support: {
                        landline: [customerServices.rostov],
                        regional: [regional.ru]
                    },
                    email: 'rndsales@yandex-team.ru'
                },
                nnovgorod: {
                    support: {
                        landline: [customerServices.nnovgorod],
                        regional: [regional.ru]
                    }
                },
                nsk: {
                    support: {
                        landline: [customerServices.nsk],
                        regional: [regional.ru]
                    },
                    email: 'sales-nsk@yandex-team.ru'
                },
                kiev: {
                    client: {
                        landline: [
                            [supportPhone, 0, iget2('i-office-contacts', 'otdel-klientskogo-servisa-po', 'отдел клиентского сервиса, по будням с 5:00 до 24:00')]
                        ]
                    },
                    email: 'kiev-sales@yandex-team.com.ua'
                },
                ukr: {
                    client: {
                        landline: [
                            [supportPhone, 0, iget2('i-office-contacts', 'otdel-klientskogo-servisa-po', 'отдел клиентского сервиса, по будням с 5:00 до 24:00')]
                        ]
                    },
                    email: 'adv@yandex-team.com.ua'
                },
                kaz: {
                    support: {
                        landline: [customerServices.kaz],
                        regional: [regional.kaz]
                    },
                    email: 'kaz-media@yandex.kz'
                },
                tr: {
                    email: 'destek@direct.yandex.com.tr'
                },
                blr: {
                    support: {
                        landline: [customerServices.blr],
                        regional: [regional.blr, regional.blrAdditional]
                    }
                },
                /* показываем баяну обычный номер */
                other: {
                    support: {
                        landline: [customerServices.other],
                        regional: [regional.other]
                    }
                }
            }
        };
    })
);
