BEM.decl('i-pcode-script__frame-api', {

    onSetMod: {
        js: function() {
            this.loadScript();
        }
    },

    /**
     * Возвращает true если скрипт загружен
     * @return {Boolean}
     */
    isLoaded: function() {
        return this._isLoaded;
    },

    /**
     * Загружает скрипт, если он не загружен
     */
    loadScript: function() {
        var script = document.createElement('script');

        if (!this._isLoaded) {
            script.src = 'https://yastatic.net/pcode/media/frame-api-simple.js';

            script.onload = script.onreadystatechange = function() {
                this._isLoaded = true;
                this.trigger('loaded');
            }.bind(this);

            document.body.appendChild(script);
        }
    }

}, {

    /**
     * Создает/возвращает инстанс блока
     * @return {BEM}
     */
    getOrCreate: function() {
        return this._instance || (this._instance = BEM.create('i-pcode-script__frame-api'));
    }

});
