(function() {
    var confirm = BEM.blocks['b-confirm'],
        MODELS_TYPES = ['phrase', 'retargeting', 'interest', 'relevance-match', 'dynamic-condition', 'feed-filter'];

    //Не использую BEM.DOM потому что у блока нет dom-представления
    BEM.decl('i-phrases-prices-helper', {
        onSetMod: {
            js: function() {
                this.init(this.params.type, this.params.campModel);
            }
        },

        /**
         * Инициализирует хелпер для работы с моделями ключевых фраз
         * @param {String|'all'|'prices'|'phrases'} type - тип редактирования - все поля или только ставки
         * @param {BEM.MODEL} campModel - модель кампании
         * @returns {*}
         */
        init: function(type, campModel) {
            if (type == 'all') {
                this.savedFields = {
                    phrase: [
                        'is_suspended', 'phrase_unglued_suffix', 'minus_words', 'key_words',
                        'is_deleted', 'price', 'price_context'
                    ],
                    interest: ['is_suspended', 'is_deleted', 'price_context'],
                    retargeting: ['is_suspended', 'is_deleted', 'price_context', 'price'],
                    'relevance-match': [
                        'is_suspended',
                        'is_deleted',
                        'price',
                        'price_context',
                        'search_stop',
                        'net_stop'
                    ],
                    'feed-filter': [
                        'is_suspended',
                        'is_deleted',
                        'price_cpc',
                        'price_cpa',
                        'use_default_price',
                        'filter_name',
                        'from_tab',
                        'target_funnel',
                        'condition',
                        'condition_tree',
                        'available',
                        //для фильтров по фиду в ДО
                        'condition_name',
                        'retargetings',
                        'price',
                        'price_context'
                    ],
                    'dynamic-condition': [
                        'is_suspended',
                        'is_deleted',
                        'price',
                        'price_context',
                        'condition',
                        'condition_name'
                    ]
                };
            } else if (type == 'prices') {
                this.savedFields = {
                    phrase: ['price', 'price_context'],
                    interest: ['price_context'],
                    retargeting: ['price_context', 'price'],
                    'relevance-match': ['price'],
                    'feed-filter': [
                        'price_cpc', 'price_cpa', 'price', 'price_context', 'use_default_price'
                    ],
                    'dynamic-condition': ['price', 'price_context']
                };
            } else if (type == 'phrases') {
                this.savedFields = {
                    phrase: ['is_suspended', 'phrase_unglued_suffix', 'minus_words', 'key_words', 'is_deleted'],
                    interest: ['is_suspended', 'is_deleted'],
                    retargeting: ['is_suspended', 'is_deleted'],
                    'relevance-match': ['is_suspended', 'is_deleted', 'search_stop', 'net_stop'],
                    'feed-filter': ['is_suspended'],
                    'dynamic-condition': ['is_suspended', 'condition', 'condition_name']
                };
            } else {
                throw new Error(this.__self._name + ' unsupported type ' + type);
            }

            this.currency = campModel.get('currency');
            this.campModel = campModel;

            return this.dropCache();
        },

        /**
         * Валидирует все модели m-phrase-bidable и m-retargeting-bidable на странице
         * @param {Object} options
         * @param {Boolean} options.validateAll
         * @returns {Boolean}
         */
        validate: function(options) {
            this.errors = [];

            options = options || {};

            var isValid = true,
                res;

            this.eachModel(function(model, type) {
                if (this.isModelChanged(model, type) || options.validateAll) {
                    res = model.validate();
                    isValid = !!res.valid && isValid;
                    this.errors = this.errors.concat(res.errors);
                }
            }, this);

            return isValid;
        },

        getSavedFields: function(modelType) {
            if (this.savedFields[modelType]) return this.savedFields[modelType];

            throw new Error(this.__self._name + ' unsupported model type ' + modelType);

        },

        /**
         * Возвращает значения полей модели (отфильтровав служебные и не нужные в данном типе редактирования)
         * @param {MODEL} model
         * @param {String|'phrase'|'retargeting'} type - тип модели
         * @returns {Object}
         */
        getModelData: function(model, type) {
            var data = {};

            this.getSavedFields(type).forEach(function(fieldName) {
                data[fieldName] = model.get(fieldName);
            });

            return data;
        },

        /**
         * Есть ли изменения в данной модели
         * @param {BEM.MODEL} model - модель
         * @param {String|'phrase'|'retargeting'|'dynamic-condition'|'feed-filter'} type - тип модели
         * @param {boolen} debug - включить вывод в консоль измененных полей
         * @returns {Boolean}
         */
        isModelChanged: function(model, type, debug) {
            var changed = false,
                savedFields = this.getSavedFields(type),
                fields = [];

            if (type == 'feed-filter') {
                savedFields = savedFields.filter(function(fieldName) {
                    // при установке цены по умолчанию не учитывать изменения в price_cpa/price_cpc
                    if (~['price_cpc', 'price_cpa'].indexOf(fieldName) && model.get('use_default_price')) return false;

                    // при стратегии оптимизации кликов не учитывать изменения в price_cpa
                    if (fieldName == 'price_cpa' && !model.get('is_cpa')) return false;

                    // при стратегии оптимизации cpa не учитывать изменения в price_cpc
                    if (fieldName == 'price_cpc' && model.get('is_cpa')) return false;

                    return true;
                })
            }

            savedFields.forEach(function(fieldName) {
                var isChanged = model.isChanged(fieldName);

                changed = changed || isChanged;

                isChanged && (fields.push(fieldName))
            });

            return changed;
        },

        /**
         * Есть ли вообще на странице кампании измененные модели фраз/категорий/условий ретаргетинга
         * @returns {Boolean}
         */
        hasChangedModels: function(debug) {
            var isChanged = false;

            this.eachModel(function(model, type) {
                isChanged = isChanged || this.isModelChanged(model, type, debug);
            }, this);

            return isChanged;
        },

        /**
         * Делает перебор по всем моделям m-phrase-bidable, m-retargeting-bidable, dm-dynamic-condition, dm-feed-filter на странице
         * @param {Function} callback
         * @param {BEM} ctx - контекст выполнения коллбэка
         * @returns {BEM}
         */
        eachModel: function(callback, ctx) {
            var modelNames = {
                phrase: 'm-phrase-bidable',
                interest: 'm-interest-bidable',
                retargeting: 'm-retargeting-bidable',
                'relevance-match': 'm-relevance-match'
            };

            MODELS_TYPES.forEach(function(type) {
                BEM.MODEL.forEachModel(
                    function() { callback.call(ctx, this, type); },
                    ({
                        'feed-filter': { name: 'dm-feed-filter' },
                        'dynamic-condition': { name: 'dm-dynamic-condition' }
                    })[type] || {
                        name: modelNames[type] || 'm-retargeting-bidable',
                        parentName: this.campModel.getChildGroupModelName(),
                        parentId: '*'
                    });
            }, this);

            return this;
        },

        eachField: function(callback, ctx) {
            MODELS_TYPES.forEach(function(type) {
                this.eachFieldType(type, callback, ctx);
            }, this);

            return this;
        },

        eachFieldType: function(type, callback, ctx) {
            this.getSavedFields(type).forEach(function(fieldName) {
                callback.call(ctx, fieldName, type)
            });

            return this;
        },

        dropCache: function() {
            this.errors = [];

            return this;
        },

        //alkaline@todo DIRECT-42185
        showWarning: function(onYes, onNo, ctx) {
            var pricesWarningCount = 0;

            BEM.MODEL.forEachModel(function() {
                pricesWarningCount = pricesWarningCount + this.get('priceWarningsCount');
            }, { name: 'm-phrases-list', id: '*' });

            if (pricesWarningCount) {
                var minPay = u.currencies.getConst(this.currency, 'BIG_RATE'),
                    formattedMinPay = u.currencies.formatSum(this.currency, minPay);

                confirm.open({
                    limited: 'yes',
                    message: [
                        iget2('i-phrases-prices-helper', 'vnimanie', 'Внимание!'),
                        u.pluralForms(
                            iget2('i-phrases-prices-helper', 'vami-ustanovleno-s-stavka', 'Вами установлено {foo} {ставка|ставки|ставок} больше {bar}.', {
                                foo: pricesWarningCount,
                                bar: formattedMinPay
                            }),
                            pricesWarningCount),
                        iget2('i-phrases-prices-helper', 'vy-uvereny-chto-hotite', 'Вы уверены, что хотите сохранить?')
                    ],
                    onYes: function() {
                        onYes.call(ctx);
                    },
                    onNo: function() {
                        onNo.call(ctx);
                    }

                }, ctx);
            } else {
                onYes.call(ctx);
            }
        }
    }, {

        instances: {},

        getInstance: function(type, campModel) {
            var id = type + '_' + campModel.get('currency');

            return this.instances[id] ||
                (this.instances[id] = BEM.create('i-phrases-prices-helper', { type: type, campModel: campModel }));
        }

    });
})();
