describe('i-phrases-separate-into-groups', function() {

    describe('utils', function() {
        var sandbox;

        beforeEach(function() {
            sandbox = sinon.sandbox.create();
        });

        afterEach(function() {
            sandbox.restore();
        });


        describe('getDisplayConditionsType', function() {

            describe('Вернет crypta', function() {

                it('Eсли есть ретаргетинг по интересам', function() {
                    var data = {
                        retargetingInterests: {
                            context: [
                                { condition_name: 'something' }
                            ]
                        }
                    };

                    expect(u['i-phrases-separate-into-groups']._getDisplayConditionsType(data)).to.be.eq('crypta');

                });

                it('Eсли нет ни фраз, ни ретаргетинга', function() {
                    var data = {
                        retargetingInterests: { context: [] },
                        phrases: {
                            declined: [],
                            low_ctr: [],
                            active: [],
                            suspended: [],
                            context: []
                        },
                        retargetings: {
                            context: []
                        }
                    };

                    expect(u['i-phrases-separate-into-groups']._getDisplayConditionsType(data)).to.be.eq('crypta');
                });

            });

            describe('Вернет keywords', function() {

                it('Если есть фразы', function() {
                    var data = {
                        retargetingInterests: { context: [] },
                        phrases: {
                            declined: [],
                            low_ctr: [],
                            active: [],
                            suspended: [],
                            context: [{ condition_name: 'something' }]
                        }
                    };

                    expect(u['i-phrases-separate-into-groups']._getDisplayConditionsType(data)).to.be.eq('keywords');
                });

                it('Если есть ретаргетинг', function() {
                    var data = {
                        retargetingInterests: { context: [] },
                        phrases: {
                            declined: [],
                            low_ctr: [],
                            active: [],
                            suspended: [],
                            context: [{ condition_name: 'something' }]
                        },
                        retargetings: {
                            context: [{ condition_name: 'something' }]
                        }
                    };

                    expect(u['i-phrases-separate-into-groups']._getDisplayConditionsType(data)).to.be.eq('keywords');
                });

            });

        });

    });

});
