(function() {
    var common = function(phrase, group, data) {
            phrase || (phrase = {});

            var campaign = data.campaign,
                currency = campaign.currency,
                priceLimits = u.bids.getLimits(u.campaign.getCampaignModelName(campaign.mediaType), currency),
                minPrice = Number(priceLimits.minPrice.value),
                maxPrice = Number(priceLimits.maxPrice.value),
                minPay = priceLimits.bigRate && Number(priceLimits.bigRate.value);

             //с сервера приходят строки '0' и '1'
            ['context_stop_flag', 'declined', 'nobsdata'].map(function(name) {
                phrase[name] = phrase[name] == '1' ? 1 : 0;
            });

            phrase.errors = {
                price: (phrase.price < minPrice || phrase.price > maxPrice),
                price_context: (phrase.price_context < minPrice || phrase.price_context > maxPrice)
            };

            phrase.warnings = {
                price: u._.isUndefined(minPay) ? false : (phrase.price > minPay),
                price_context: u._.isUndefined(minPay) ? false : (phrase.price_context > minPay)
            };

            //phrase.bannerId = group.firstBid;
            phrase.adgroup_id = group.adgroup_id;
            phrase.ctx_clicks = phrase.ctx_clicks || 0;
            phrase.is_suspended = !!+phrase.is_suspended;
            phrase.disabled_tragic = +phrase.disabled_tragic || 0;
            phrase.is_deleted = false;

            if (group.editable_price && phrase.premium && phrase.premium.length &&
                phrase.premium[phrase.premium.length - 1].bid_price != phrase.premium[0].bid_price) {

                campaign.showPmax = true;
            }

            return phrase;
        },
        filterRetargetingsByType = function(condition, type, data) {
            var conditionData = data.all_retargeting_conditions[condition.ret_cond_id];

            return u.retargeting.isConditionType(conditionData, type);
        },
        conditions = function(ph, group, data) {
            ph || (ph = {});

            var currency = data.campaign.currency,
                currencyHash = u.currencies.get(currency),
                minPrice = currencyHash.MIN_PRICE,
                maxPrice = currencyHash.MAX_PRICE,
                minPay = currencyHash.BIG_RATE;

            ph.search_editable_price = true;
            ph.context_editable_price = true;
            ph.can_edit_price = true;
            ph.type = 'dynamicCondition';
            ph.modelName = 'dm-dynamic-condition';

            ph.errors = {
                price: (ph.price < minPrice || ph.price > maxPrice),
                price_context: (ph.price_context < minPrice || ph.price_context > maxPrice)
            };

            ph.warnings = {
                price: (ph.price > minPay),
                price_context: (ph.price_context > minPay)
            };

            ph.adgroup_id = group.adgroup_id;
            ph.ctx_clicks = ph.ctx_clicks || 0;
            ph.is_suspended = !!+ph.is_suspended;
            ph.is_deleted = false;

            return ph;
        },
        sortConditions = function(elements, group, data) {
            // declined нет, потому что условия нацеливания не модерируются
            // low_ctr нет по ТЗ
            var sorted = { context: [], active: [], suspended: [] };

            elements && elements.forEach(function(el) {
                el = conditions(el, group, data);
                sorted['active'].push(el);
            });

            //сортируем в алфавитном порядке
            ['active'].forEach(function(groupName) {
                sorted[groupName].sort(function(phraseA, phraseB) {
                    var sortTrRes,
                        valA = phraseA.condition_name ? phraseA.condition_name.toLowerCase() : '',
                        valB = phraseB.condition_name ? phraseB.condition_name.toLowerCase() : '';

                    //для турции своя лексикографическая сортировка
                    if (data.lang == 'tr') {
                        sortTrRes = u.sortTr(valA, valB);

                        return sortTrRes;
                    } else {
                        if (valA < valB) {
                            return -1;
                        } else if (valA > valB) {
                            return 1;
                        }
                    }

                    return 0;
                });

            });

            return sorted;
        },
        interests = function(item, tree) {
            // в одной группе категории интересов должны быть уникальными, поэтому
            // используем id категории в качестве id интереса
            item.target_category_id = +item.target_category_id;

            item.is_interest = true;
            item.phrase = item.category_name;
            item.interest_name = item.category_name;
            item.interest_name_escape = u.hellipCut(u.escapeHtmlSafe(item.category_name), 40);

            item.category_path = u['interests-targeting'].getPath(item.target_category_id, tree, 1);
            item.category_path_escape = u.escapeHtmlSafe(item.category_path);

            item.search_editable_price = 0;
            item.context_editable_price = 1;
            item.can_edit_price = 1;

            item.type = 'interest';
            item.modelName = 'm-interest-bidable';

            return item;
        },
        relevance_match = function(item, group) {
            var opts = item._opts || '';

            item.search_stop = +/search_stop/.test(opts);
            item.net_stop = +/net_stop/.test(opts);

            item.is_relevance_match = true;
            item.state = 'active';
            item.search_editable_price = true;
            item.platform = 'search';
            item.errors = u._.extend(item.errors, { search: [] });
            item.warnings = u._.extend(item.warnings, { search: [] });

            item.bid_id = item.bid_id || '0';
            item.price = item.price || 0;

            item.type = 'relevance_match';
            item.modelId = group.modelId;
            item.modelName = 'm-relevance-match';

            return item;
        },
        retargetings = function(ph, data, options, platform) {
            var text,
                fullData = data.all_retargeting_conditions[ph.ret_cond_id];

            ph.is_retargeting = 1;
            text = fullData ? fullData.condition_name : '';
            ph.condition_name_escape = u.hellipCut(u.escapeHtmlSafe(text), 40);

            ph.condition_name = text;
            ph.phrase = text;

            ph.search_editable_price = false;
            ph.context_editable_price = platform === 'net' ? 1 : 0;
            ph.can_edit_price = 1;
            ph.type = 'retargeting';
            ph.conditions_type = fullData.retargeting_conditions_type || 'metrika_goals';
            ph.modelName = (options || {}).isNotBiddable ? 'm-retargeting-condition' : 'm-retargeting-bidable';

            return ph;
        },
        phrases = function(ph, data, options) {
            ph.is_phrase = 1;

            ph.minus_words = u.phraseFormatter.getMinusWords(ph.phrase);
            ph.key_words = u.phraseFormatter.getKeyWords(ph.phrase);

            //склейка-расклейка стоп-слов: например при вводе i phone она предлагает преобразовать фразу в i+phone
            if (ph.fixation && ph.fixation.length) {
                ph.stopword_fixated = 1;
                ph.key_words_fix_on = ph.key_words;
                ph.key_words_fix_off = u.phraseFormatter.getFixOff(ph.fixation, ph.key_words);
            }

            ph.phrase_minus_words_length = u.minusWords.arrayToString(ph.minus_words).length;
            //склейка-расклейка по минус словам: красная, красная площадь -> красная -площадь, красная площадь
            ph.unglued = !!ph.phrase_unglued_suffix;
            ph.ctr = ph.Ctr;
            // фразу можно редактировать на поиске
            // DIRECT-62390 - нужно использовать флаг nobsdata
            ph.search_editable_price = (ph.nobsdata || ph.rank > u.consts('MIN_PHRASE_RANK_WARNING')) && !ph.declined;
            if (ph.nobsdata) {
                data.campaign.nobsdata = 1;
            }
            if (!ph.nobsdata) {
                data.campaign.hasPhrasesWithBsData = 1;
            }
            //heliarian - неактуально, фразу можно редактировать только на поиске, у нас нет фраз отключенных на поиске
            //задача на разобраться - DIRECT-52001
            ph.context_editable_price = !ph.search_editable_price && !ph.context_stop_flag && !ph.declined;
            ph.can_edit_price = ph.search_editable_price || ph.context_editable_price;
            ph.type = 'phrase';
            ph.modelName = (options || {}).isNotBiddable ? 'm-phrase-text' : 'm-phrase-bidable';
            ph.t_lowctr = ph.rank && ph.rank > u.consts('MIN_PHRASE_RANK_WARNING') &&
                ph.rank < u.consts('CONSTS.MAX_PHRASE_RANK_WARNING');

            return ph;
        },
        sort = function(elements, group, data, options) {
            //low_ctr: [], context: [] - больше не нужны
            var sorted = { declined: [], low_ctr: [], context: [], search: [], active: [], suspended: [] },
                groupName;

            elements && elements.map(function(el) {
                // DIRECT-64420 - DEFAULT_RANK=10000
                if (typeof el.rank !== 'number') {
                    el.rank = 10000;
                }

                el = common(el, group, data);
                el = phrases(el, data, options);

                //режим показа, когда показываем только фразы и группы по которым были предупреждения о смене позиции
                //warnplace0 - фраза была вытеснена из гарантии
                //warnplace1 - фраза была вытеснена из 1-го места
                //warnplace2 - фраза была вытеснена из спецразмещения
                if (data.FORM.wp && !(data.warnplace0 && data.warnplace0[el.id] ||
                    data.warnplace1 && data.warnplace1[el.id] || data.warnplace2 && data.warnplace2[el.id])) {

                    return;
                }

                if (+el.id) {
                    groupName = el.declined ?
                        'declined' :
                        //nobsdata - ошибка на сервере, почему-то не пришли данные по фразам
                        (el.rank > 2 || el.nobsdata || group.isEmptyGroup) ?
                            ((options || {}).hasSuspended && el.is_suspended ? 'suspended' : 'active') :
                            'context';
                } else {
                    groupName = (options || {}).hasSuspended && el.is_suspended ? 'suspended' : 'active';
                }

                sorted[groupName].push(el);
            });

            //сортируем в алфавитном порядке
            ['declined', 'active', 'suspended', 'context'].forEach(function(groupName) {
                sorted[groupName].sort(function(phraseA, phraseB) {
                    var sortTrRes,
                        valA = phraseA.phrase ? phraseA.phrase.toLowerCase() : '',
                        valB = phraseB.phrase ? phraseB.phrase.toLowerCase() : '';

                    //для турции своя лексикографическая сортировка
                    if (data.lang == 'tr') {
                        sortTrRes = u.sortTr(valA, valB);
                        return sortTrRes;
                    } else {
                        if (valA < valB) {
                            return -1;
                        } else if (valA > valB) {
                            return 1;
                        }
                    }

                    return 0;
                });

            });

            return sorted;
        },
        /**
         * Возвращает признак наличия фраз в группе
         * @param {Object} phrases
         * @returns {Boolean}
         */
        hasPhrases = function(phrases) {
            return ['declined', 'low_ctr', 'context', 'active', 'suspended', u.consts('isSearchRetargetingEnabled') && 'search']
                .filter(Boolean)
                .some(function(name) {
                    return !!phrases[name].length;
                });
        },
        /**
         * Возвращает тип «Условия показа»
         * @param {Object} sortedGroup
         * @returns {String}
         */
        getDisplayConditionsType = function(sortedGroup) {
            if (sortedGroup.retargetingInterests.context.length) {
                // интересы и соцдем
                return 'crypta';
            } else if (hasPhrases(sortedGroup.phrases) || sortedGroup.retargetings.context.length) {
                // ключевые фразы
                return 'keywords';
            } else {
                return 'crypta';
            }
        };

    u.register({

        'i-phrases-separate-into-groups': {

            _getDisplayConditionsType: getDisplayConditionsType,

            /**
             * Преобразует и сортирует данные по фразам, условиям ретаргетинга и условиям нацеливания
             * @param {Object} data
             * @param {Object} options
             * @param {Boolean} options.isNotBiddable
             * @param {Boolean} options.hasSuspended
             * @return {Object}
             */
            patch: function(data, options) {
                var campaign = data.campaign,
                    interestTree = data.interest_categories &&
                        u['interests-targeting'].transformServerData(data.interest_categories);

                //@heliarian deprecated, задача на удаление - DIRECT-51995
                campaign.hasPlatformSelect = false;
                //@heliarian deprecated, задача на удаление DIRECT-51996
                campaign.showPmax = false;

                campaign.groups.map(function(group) {
                    var groupRetargetings = group.retargetings || [],
                        groupSearchRetargetings = group.search_retargetings || [];

                    group.sorted = {};

                    group.sorted.phrases = sort(group.phrases, group, data, options);

                    group.sorted.retargetings = {
                        //@heliarian - всегда пусто для условия ретаргетинга
                        declined: [],
                        //@heliarian - deprecated - удалить DIRECT-51994
                        low_ctr: [],
                        //@heliarian - всегда пусто для условия ретаргетинга
                        active: [],
                        suspended: [],
                        search: [],
                        context: groupRetargetings
                            .filter(function(el) {
                                return filterRetargetingsByType(el, 'metrika_goals', data);
                            })
                            .map(function(el) {
                                //применяем фильтры общие для фраз и условий ретаргетинга
                                el = common(el, group, data);
                                //применяем фильтры специфичные для условий ретаргетинга
                                el = retargetings(el, data, options, 'net');

                                return el;
                            })
                    };

                    if (u.consts('isSearchRetargetingEnabled')) {
                        group.sorted.searchRetargetings = {
                            //@heliarian - всегда пусто для условия ретаргетинга
                            declined: [],
                            //@heliarian - deprecated - удалить DIRECT-51994
                            low_ctr: [],
                            //@heliarian - всегда пусто для условия ретаргетинга
                            active: [],
                            suspended: [],
                            context: [],
                            search: groupSearchRetargetings
                                .filter(function(el) {
                                    return filterRetargetingsByType(el, 'metrika_goals', data);
                                })
                                .map(function(el) {
                                    //применяем фильтры общие для фраз и условий ретаргетинга
                                    el = common(el, group, data);
                                    //применяем фильтры специфичные для условий ретаргетинга
                                    el = retargetings(el, data, options, 'search');

                                    return el;
                                })
                        };
                    }

                    group.sorted.retargetingInterests = {
                        //@heliarian - всегда пусто для условия ретаргетинга
                        declined: [],
                        //@heliarian - deprecated - удалить DIRECT-51994
                        low_ctr: [],
                        //@heliarian - всегда пусто для условия ретаргетинга
                        active: [],
                        suspended: [],
                        search: [],
                        context: groupRetargetings
                            .filter(function(el) {
                                return filterRetargetingsByType(el, 'interests', data);
                            })
                            .map(function(el) {
                                //применяем фильтры общие для фраз и условий ретаргетинга
                                el = common(el, group, data);
                                //применяем фильтры специфичные для условий ретаргетинга
                                el = retargetings(el, data, options, 'net');

                                return el;
                            })
                    };

                    group.sorted.interests = {
                        declined: [],
                        low_ctr: [],
                        active: [],
                        suspended: [],
                        search: [],
                        context: group.target_interests ?
                            group.target_interests.map(function(el) {
                                //применяем общие фильтры
                                el = common(el, group, data);
                                //применяем фильтры специфичные для условий ретаргетинга
                                el = interests(el, interestTree);

                                return el;
                            }) :
                            []
                    };

                    group.sorted.relevance_match = {
                        declined: [],
                        low_ctr: [],
                        search: [],
                        context: [],
                        suspended: [],
                        active: group.relevance_match && group.relevance_match.length ?
                            group.relevance_match.map(function(el) {
                                el = common(el, group, data);
                                el = relevance_match(el, group);

                                return el;
                            }) :
                            []
                    };

                    if (u.campaign.isCpm(campaign.mediaType)) {
                        group.displayConditions = getDisplayConditionsType(group.sorted);

                        // @skywhale в рамках DIRECT-72987:
                        // добавляем возможность редактировать ставку условия показа для крипты,
                        // аудитория (retargetings) для cpm-кампаний может быть только одна(в будующем поменяется)
                        if (group.has_general_limit_price && group.displayConditions === 'crypta' &&
                            group.retargetings && group.retargetings.length) {

                            group.general_limit_price = group.retargetings[0].price_context;
                        }
                    }

                    group.sorted.dynamicConditions = sortConditions(group.dynamic_conditions, group, data);

                    //@heliarian deprecated, задача на удаление - DIRECT-51995
                    if (group.sorted.phrases.context && group.sorted.phrases.context.length ||
                        group.retargetings && group.retargetings.length) {
                        data.campaign.hasPlatformSelect = true;
                    }

                    var strategy = data.campaign.strategy,
                        count = 1;

                    //@heliarian - есть подозрение, что priceWarningsCount не нужно
                    //раньше отвечало за показ предупреждения о том, что есть N фраз больше определенной цены
                    //задача на разобраться - DIRECT-51999
                    group.priceWarningsCount = 0;
                    group.active_size = 0;
                    group.retargeting_size = 0;

                    ['active', 'suspended', 'declined', 'context', u.consts('isSearchRetargetingEnabled') && 'search']
                        .filter(Boolean)
                        .forEach(function(groupName) {
                            group.sorted.phrases[groupName] && group.sorted.phrases[groupName].forEach(function(phrase) {
                                if (groupName == 'active') {
                                    group .active_size++;
                                }
                                !strategy.is_autobudget &&
                                    (strategy.name != 'different_places' || !strategy.is_search_stop) &&
                                        phrase.warnings && phrase.warnings.price && group .priceWarningsCount++;

                                !strategy.is_autobudget && (strategy.name == 'different_places') && phrase.warnings &&
                                    phrase.warnings.price_context && group .priceWarningsCount++;

                                phrase.modelId = phrase.flag_new || !+phrase.id ?
                                    'new_' + count :
                                    phrase.id || 'new_' + count;

                                phrase.state = groupName;

                                if (phrase.flag_new || !+phrase.id) {
                                    count++;
                                }
                            });

                            group.sorted.retargetings[groupName] && group.sorted.retargetings[groupName]
                                .forEach(function(retargeting) {
                                    retargeting.warnings && retargeting.warnings.price_context &&
                                    group .priceWarningsCount++;

                                    retargeting.modelId = retargeting.ret_cond_id;

                                    retargeting.state = 'context';

                                    group .retargeting_size++;
                                });

                            if (u.consts('isSearchRetargetingEnabled')) {
                                group.sorted.searchRetargetings[groupName] && group.sorted.searchRetargetings[groupName]
                                    .forEach(function(retargeting) {
                                        retargeting.warnings && retargeting.warnings.price &&
                                        group .priceWarningsCount++;

                                        retargeting.modelId = 'search-' + retargeting.ret_cond_id;

                                        retargeting.state = 'search';

                                        group .retargeting_size++;
                                    });
                            }

                            group.sorted.retargetingInterests[groupName] && group.sorted.retargetingInterests[groupName]
                                .forEach(function(retargeting) {
                                    retargeting.modelId = retargeting.ret_cond_id;
                                    retargeting.state = 'context';
                                });

                            group.sorted.interests[groupName] && group.sorted.interests[groupName]
                                .forEach(function(interest, i) {
                                    interest.warnings && interest.warnings.price_context && group .priceWarningsCount++;

                                    interest.modelId = interest.ret_id + '-' + interest.target_category_id;

                                    interest.state = 'context';

                                    group .interest_size++;
                                });
                        });

                });

                return data;
            }
        }

    });

})();
