u.register({

    'i-process-campaign-data': {
        /**
         * Модифицирует данные кампании
         * @param {Object} data
         * @return {Object}
         */
        patch: function(data) {
            var campaign = data.campaign;

            //common
            campaign.ulogin = data.FORM.ulogin;

            campaign.status_click_track = Boolean(+campaign.status_click_track);

            // tags
            if (campaign.tags) {
                campaign.tags = campaign.tags.map(function(tag) {
                    return {
                        id: tag.tag_id, //@todo желательно присылать с сервера id (в модели компании используется поле id)
                        value: tag.value,
                        uses_count: tag.uses_count
                    }
                });
            }

            // retargetings
            var isGoBackMultiEdit = data.FORM.cmd == 'gobackMultiEdit';

            campaign.groups.forEach(function(group) {
                if (isGoBackMultiEdit || !group.retargetings) {//#DIRECT-19372
                    group.retargetings = [];

                    group.retargeting_conditions_id && group.retargeting_conditions_id.split(',').forEach(function(id) {
                        if (group.retargetings.indexOf(id) < 0 ) {
                            group.retargetings.push({
                                ret_cond_id: id,
                                condition_name: data.all_retargeting_conditions[id].condition_name
                            });
                        }
                    });
                }
            });

            return data;
        }
    }

});
