BEM.decl({ name: 'i-region-suggest-dataprovider', baseBlock: 'i-request_type_ajax' }, {
    get: function(request, callback) {
        var requestThreshold = this.params.requestThreshold || 1;

        return request.length >= requestThreshold ?
            this.__base(
                { text: request },
                function(data) {
                    var groups = BEM.blocks['i-utils'].groupBy(data, function(item) {
                            return item.name;
                        }),
                        cbData = data.map(function(item) {
                            var title = item.name;

                            if (groups[item.name].length > 1) {
                                title += ' (' + item.parent_name + ')';
                            }
                            //@see islands-control/common.blocks/input/_suggest/input_suggest_yes.js:362
                            return ['text', { data: title, js: { val: item.name, id: item.id } }]; //@todo: phonecode?
                        });
                    callback.call(this, cbData);
                },
                { dataType: 'json' }) :
            callback.call(this, { items: [] });
    }
});
