BEM.decl({ block: 'i-request_type_ajax' }, {
    _logPassportError: function(resp, request, params) {
        var response = resp || {},
            host = window.location.host,
            isPassportRequest = u.isPassportSupportPinCodeUrl(params.url || '');

        if (!isPassportRequest || (response.responseJSON || {}).status === 'ok') {
            return;
        }

        this._logError(response.responseText, {
            responseStatus: response.status,
            requestUid: request.uid,
            url: params.url,
            login: BEM.blocks['i-global'].param('login')
        });

        BEM.blocks['b-metrika2'] && BEM.blocks['b-metrika2'].params({
            params: {
                'pin-code-error': 1
            }
        });
    },

    _logError: function(error, additionalParams) {
        var Rum = window.Ya && window.Ya.Rum;

        if (Rum && Rum.logError) {
            Rum.logError({
                message: error,
                block: 'i-request_type_ajax',
                source: 'passport',
                level: Rum.ERROR_LEVEL.ERROR,
                additional: additionalParams || {}
            });
        }
    },

    _do: function(request, onSuccess, onError, params) {
        var _this = this;

        if (_this._number > _this._preventNumber) { // условие на случай, если кто-то синхронно позовет preventCallbacks
            var args = arguments,
                settings = {
                    data: params.data ? $.extend({}, params.data, request) : request
                },
                done = _this._wrapCallback(function(respArgs, requestNumber, number) {
                    _this._onSuccess(_this._buildCacheKey(request, params), request, respArgs[0], params);

                    //-- добавлено для валидации данных, происходящих в ajax-запросе
                    u.consts('is_beta') && BEM.blocks['i-request_type_ajax'].trigger('response', {
                        cmd: settings.data && settings.data.cmd,
                        data: respArgs && respArgs[0]
                    });
                    //---
                    _this._allowCallback(requestNumber, number) &&
                    onSuccess.apply(params.callbackCtx, respArgs);

                    _this._logPassportError.call(_this, respArgs[2], request, params);
                }),
                fail = _this._wrapCallback(function(respArgs, requestNumber, number) {
                    if (!_this._allowCallback(requestNumber, number)) {
                        return;
                    }
                    if (_this ._retryCount-- > 0) {
                        setTimeout(
                            function() {
                                _this._do.apply(_this, args);
                            },
                            params.retryInterval
                        );
                    } else {
                        onError && onError.apply(params.callbackCtx, respArgs);
                        _this._logPassportError.call(_this, respArgs[0], request, params);
                    }
                });

            $.each([
                'url',
                'dataType',
                'timeout',
                'type',
                'jsonp',
                'jsonpCallback',
                'xhrFields'
            ].concat(params.paramsToSettings || []), function(i, name) {
                settings[name] = params[name];
            });

            /**
             * Переопределено для работы с i-ajax-captcha
             * Переопределяемый вариант (из lego/romochka) делал запрос с помощью конструкции
             * $.ajax(settings).done(done).fail(fail);
             * и внутри settings не было обработчиков error и success,
             * а i-ajax-captcha имеет доступ только к settings, которые использует для повторной отправки
             * запроса. В данном переопределении обработчики складываются в settings
             * и когда i-ajax-captcha повторно отправляет запрос, то на успех ввода капчи вызывается код,
             * который и должен был вызваться если бы не было капчи
             */
            // в базовом блоке вот такой код
            // $.ajax(settings).done(done).fail(fail);
            settings.error = fail;
            settings.success = done;
            //сохраняем ссылку на ajax, нужно для метода отмены запроса
            this._xhr = $.ajax(settings);
        }
    },
    /**
     * Отменяет запрос
     */
    abort: function() {
        this._xhr && this._xhr.readyState != 4 && this._xhr.abort && this._xhr.abort();
    }
});
