BEM.decl({ block: 'i-request_type_file', baseBlock: 'i-request' }, {

    onSetMod: {
        js: function() {
            this.__base();
        }
    },

    /**
     * @example
     *
     * Example for Request's param variables
     *
     *
     * request = {
     *   variableName: inputElement || jQuery [inputElement, inputElement, inputElement, ...]
     *   variableName2: inputElement || jQuery [inputElement, inputElement, inputElement, ...]
     *   variableName3: 'variableValue'
     * }
     *
     * Request param will convert to this:
     *
     * request = {
     *   files: [
     *      inputElement,
     *      inputElement,
     *      inputElement,
     *      ...
     *   ],
     *   data: {
     *     variableName: 'variableValue',
     *     ...
     *   }
     * }
     *
     * @param {Object} request
     * @param {Function} onSuccess
     * @param {Function} onError
     * @param {Object} params
     * @private
     */
    _get: function(request, onSuccess, onError, params) {

        var newRequest = this._parseRequest(request);

        newRequest.data = $.extend(newRequest.data, params.data || {});

        params = $.extend({ timeout: 10000 }, params);

        this._do(newRequest, onSuccess, onError, params);
    },

    _parseRequest: function(request) {

        var variableName,
            newRequest = {
                files: [],
                data: {}
            };

        if (request instanceof Object) {
            for (variableName in request) {
                var variable = request[variableName];
                this._isFile(variable) ?
                    newRequest.files = newRequest.files.concat(this._unsafeInputElements(variable)) :
                    newRequest.data[variableName] = variable;
            }
        } else {
            throw new Error('request param must be an Object');
        }

        return newRequest;
    },

    _do: function(request, onSuccess, onError, params) {

        var files = request.files,
            data = request.data,
            isHtml5 = files[0] && files[0].files && window.FormData;

        isHtml5 ?
            this._requestByXhr(files, data, onSuccess, onError, params) :
            this._requestByIframe(files, data, onSuccess, onError, params);
    },

    _requestByXhr: function(files, data, onSuccess, onError, params) {

        var _this = this,
            fData = new window.FormData(),
            paramName,
            fileReferences,
            done,
            fail,
            settings = {
                data: fData,
                cache: false,
                type: 'POST',
                contentType: false,
                processData: false
            };

        fileReferences = this._getFileReferences(files);

        for (paramName in data) {
            fData.append(paramName, data[paramName]);
        }

        for (paramName in fileReferences) {
            /*jshint loopfunc: true */
            fileReferences[paramName].forEach(function(file) {
                fData.append(paramName, file);
            });
        }

        done = function(respArgs) {
            onSuccess.call(params.callbackCtx, respArgs);
        };

        fail = function(respArgs) {
            _this ._retryCount-- > 0 ?
                setTimeout(function() {
                    _this._do.apply(_this, arguments);
                }, params.retryInterval) :
                onError && onError.call(params.callbackCtx, respArgs);
        };

        ['url', 'dataType', 'timeout', 'type', 'jsonp', 'jsonpCallback'].concat(params.paramsToSettings ||
            []).forEach(function(name) {
                settings[name] || (settings[name] = params[name]);
            });

        this._xhr = $.ajax(settings).done(done).fail(fail);
    },

    _requestByIframe: function(files, data, onSuccess, onError, params) {

        var _this = this,
            timeoutId,
            paramName,
            /**
             * Create uniq Name for request
             */
            uniqName = 'bbannerpic' + (+new Date()),
            /**
             * Create & append to body, iframe's transport
             */
            /*jshint scripturl:true*/
            iframe =
                $('<iframe name="' + uniqName + '" id="' + uniqName + '" src="about:blank" style="display: none" />')
                .css({
                    /*jshint indent:false*/
                    position: 'absolute',
                    top: '-9999px',
                    left: '-9999px'
                })
                .appendTo(document.body),
            /**
             * Create form.
             */
            form = $('<form />')
                .attr({
                    target: uniqName,
                    method: 'POST',
                    enctype: 'multipart/form-data',
                    action: params.url
                }).css({
                    position: 'absolute',
                    top: '-9999px',
                    left: '-9999px'
                })
                .appendTo(document.body);

        data.callback = uniqName;

        for (paramName in data) {
            $('<input type="hidden" />')
                .attr({ name: paramName })
                .val(data[paramName])
                .appendTo(form);
        }

        /**
         * Replace current fileNodes & append to form
         */
        if (!this._processFiles(form, files)) {

            this.abort();

            return false;
        }

        this._killIFrame = function() {

            if (window[uniqName]) {
                try {
                    delete window[uniqName];
                } catch (e) {
                    window[uniqName] = null;
                }
            }

            if (iframe) {
                iframe.remove();
                iframe = null;
            }

            if (form) {
                form.remove();
                form = null;
            }

            clearTimeout(timeoutId);
        };

        window[uniqName] = function(respArgs) {

            _this._killIFrame();

            ($.isArray(respArgs) || $.isPlainObject(respArgs)) &&
                // нужно создать заново для того, чтобы добавились ecma методы
                (respArgs = JSON.parse(JSON.stringify(respArgs)));

            onSuccess.call(params.callbackCtx, respArgs);
        };

        // create timeout for request.
        timeoutId = setTimeout(function() {

            _this._killIFrame();

            onError && onError.call(params.callbackCtx);
        }, params.timeout);

        form.submit();

        return true;
    },

    _processFiles: function(form, files) {

        if (!form || !files) return false;

        files.length && files.forEach(function(fileInput) {
            var $fileInput = $(fileInput),
                clonedFileInput = $fileInput.clone();

            $fileInput
                .before(clonedFileInput)
                .appendTo(form);
        });

        return true;
    },

    abort: function() {

        this._xhr && this._xhr.readyState != 4 && this._xhr.abort && this._xhr.abort();

        this._killIFrame && this._killIFrame();
    },

    /**
     *
     * @param {Array} files List of HTMLInputElement's
     * @return {Object} references
     * @private
     */
    _getFileReferences: function(files) {

        var references = {};

        files.forEach(function(fileInput) {
            if (fileInput && fileInput.files) {
                for (var i = 0; i < fileInput.files.length; i++) {
                    if (fileInput.files[i]) {
                        references[fileInput.name] || (references[fileInput.name] = []);

                        references[fileInput.name].push(fileInput.files[i]);
                    }
                }
            }
        });

        return references;
    },

    _isFile: function(data) {
        return data instanceof Object &&
            (data instanceof jQuery || data instanceof HTMLInputElement || data instanceof NodeList);
    },

    _unsafeInputElements: function(files) {
        return [].concat(files.length ? Array.prototype.slice.call(files, 0) : [files]);
    }

});
