(function($) {
    var bPage = BEM.blocks['b-page'].getInstance();

    BEM.DOM.decl({ block: 'i-request', modName: 'type', modVal: 'form' }, {

        /**
         * Метод нужен для сохранения функциональности метода get
         * onSuccess и onError в контексте запроса формой бессмысленны
         * для onSuccess есть исключение, вызываем его без аргументов если форма отправляется с target = _blank
         */
        _get: function(request, onSuccess, onError, params) {
            this.submit(request, params);
            onSuccess.call(this.params.callbackCtx);
        },

        /**
         * Отправляет запрос посредством создания DOM-ноды с тегом form в теле страницы
         *
         * @param {Object} request хеш параметров для инпутов вида { <имя>: <значение> }
         * @param {Object} formParams параметры отправляемой формы
         * @param {Object} formParams.url атрибут action формы
         * @param {Object} formParams.type атрибут method формы
         * @param {Object} formParams.target атрибут target формы
         * @param {Object} formParams.name атрибут name формы
         * @param {Object} formParams.elemTag тег элементов в форме
         */
        submit: function(request, formParams) {
            var data = request || {},
                params = $.extend({}, this.params, formParams),
                elemTag = params.elemTag || '<input/>',
                form = $('<form/>', {
                    action: params.url,
                    method: params.type,
                    target: params.target,
                    name: params.name,
                    style: 'display: none;'
                });

            Object.keys(data).forEach(function(paramName) {
                var paramValue = data[paramName];

                if (!Array.isArray(paramValue))
                    paramValue = [paramValue];

                paramValue.forEach(function(value) {
                    form.append($(elemTag, { name: paramName }).val(value));
                });
            });

            form.appendTo(bPage.domElem).submit().remove();
        },

        getDefaultParams: function() {
            return {
                url: location.origin + location.pathname,
                type: 'POST',
                target: '',
                name: ''
            };
        }
    });
})(jQuery);
