(function($, undefined) {

    var defaultLimit = 15;

    BEM.decl({ block: 'i-request_type_script', baseBlock: 'i-request' }, {

        get: function(request, callback) {

            return request && this.__base(request, callback, {
                cache: true,
                callbackCtx: this
            });

        },

        _do: function(request, onSuccess, onError, params) {

            this._data ?
                this._process(request, onSuccess, params) :
                this._load(request, onSuccess, params, this.params.scriptName);

        },

        _process: function(request, onSuccess, params) {

            var data = this._filter(this._data, request);

            this.putToCache(params, request, data);
            onSuccess.call(this.params.callbackCtx, data);

        },

        _load: function(request, onSuccess, params, scriptName) {

            var _this = this,
                path = _this.params.path,
                head = document.getElementsByTagName('head')[0],
                script = document.createElement('script');

            window[scriptName] = function(data) {
                _this._data = data;
                _this._process(request, onSuccess, params);
                _this.trigger('complete');
            };

            script.src = (path !== undefined ? path : '/') + scriptName;

            _this.trigger('request');
            head.appendChild(script);

        },

        _filter: function(data, val) {}

    });

})(jQuery);
