(function() {

    var TIMEOUT = 150,
        resizeTimer = null,
        resizeCount = 0;

    BEM.decl('i-resize', {

        onSetMod: {

            js: function() {
                BEM.DOM.win.bind('resize', this._onWindowResize.bind(this));
            }

        },

        /**
         * Обработчик события изменения размеров окна
         * @private
         */
        _onWindowResize: function() {
            resizeCount || this.trigger('start');

            clearTimeout(resizeTimer);

            resizeTimer = setTimeout(function() {
                this.trigger('end');

                resizeCount = 0;
            }.bind(this), TIMEOUT);

            resizeCount++;
        }

    }, {

        /**
         * Экземпляр блока i-resize
         * @private
         * @static
         * @type {BEM}
         */
        _instance: null,

        /**
         * Создает экземпляр блока i-resize
         * @static
         * @returns {BEM}
         */
        getInstance: function() {
            return this._instance || (this._instance = BEM.create('i-resize'));
        }

    });

})();
