BEM.decl('i-retargeting-goals-data', {}, {

    /**
     * Тут хранится текущий запрос
     */
    requestPromise: null,

    /**
     * Получение целей метрики
     * @returns {Promise}
     */
    get: function() {
        this.requestPromise || (this.requestPromise = new Promise(function(resolve, reject) {

            if (this._goals) {
                resolve(u._.cloneDeep(this._goals));
            } else {
                BEM.blocks['i-web-api-request'].retargeting
                    .getGoals(u.consts('ulogin'))
                    .then(function(response) {
                        if (!response.success) {
                            reject(response);
                        } else {
                            this._goals = response.result;
                            resolve(u._.cloneDeep(response.result));
                        }
                    }.bind(this))
                    .catch(function(error) {
                        reject(error);
                    })
            }
        }.bind(this)));

        return this.requestPromise;
    },

    /**
     * Получение целей метрики в виде хеша
     * @returns {Promise}
     */
    getGoalsHash: function() {

        return new Promise(function(resolve, reject) {
            if (this._goalsHash) {
                resolve(u._.cloneDeep(this._goalsHash));
            } else {
                this.get()
                    .then(function(goals) {
                        this._goalsHash = goals.reduce(function(hash, goal) {
                            hash[goal.id] = goal;
                            return hash;
                        }, {});
                        resolve(u._.cloneDeep(this._goalsHash));
                    }.bind(this))
                    .catch(function(error) {
                        reject(error);
                    });
            }
        }.bind(this));
    }

});
