(function() {

    var INLINE_SCRIPTS = [
        'borschik:include:../../node_modules/@yandex-int/error-counter/dist/interfaceOverRum.min.js',
        'borschik:include:../../node_modules/@yandex-int/error-counter/dist/implementation.min.js',
        'borschik:include:../../node_modules/@yandex-int/error-counter/dist/filters.min.js',
        'borschik:include:../../node_modules/@yandex-int/error-counter/dist/logError.min.js',
        'borschik:include:../../node_modules/@yandex-int/error-counter/dist/logAjaxError.min.js',
    ];

    u.register({
        'i-rum-error-counter': function(isProd, region, page, login, reqId, isBrowserUnsupported) {
            var settings;

            settings = {
                project: 'direct',
                env: isProd ? 'production' : 'testing',
                platform: 'desktop',
                region: region,
                service: 'frontend',
                page: page,
                unhandledRejection: true,
                loggedin: Boolean(login),
                additional: {
                    login: login || '__INCOGNITO__',
                    perlReqId: reqId,
                    isBrowserUnsupported: isBrowserUnsupported
                }
            };

            return [';window.Ya&&Ya.Rum&&(function(){;']
                .concat(INLINE_SCRIPTS)
                .concat([
                    ';Ya.Rum.send&&Ya.Rum.initErrors&&Ya.Rum.initErrors(' + JSON.stringify(settings) + ');',
                    '})();'
                ]).join('');
        }
    });
})();
