BEM.decl({ block: 'i-searchable', modName: 'type', modVal: 'camps' }, {

    search: function(query, callback) {
        query.text = query.text.toLowerCase();

        return this.__base.apply(this, arguments);
    },

    matchRow: function(row, iterator) {
        var query = iterator.query,
            queryText = query.text;

        return (~row.searchIndex.indexOf(queryText) || ~row.desc.indexOf(queryText)) &&
            (!query.onlyFavs || row.isFav) && (!query.onlyMy || row.isMy) &&
            (!query.mediaType || query.mediaType == 'all' || query.mediaType == row.mediaType);
    },

    getTotals: function(visibleIndexes) {
        var items = this.items,
            totals = {};

        visibleIndexes.forEach(function(index) {
            var rowTotals = items[index].totals;

            for (var field in rowTotals) {
                if (rowTotals.hasOwnProperty(field)) {
                    totals[field] || (totals[field] = 0);
                    totals[field] += rowTotals[field]
                }
            }
        });

        return totals;
    }

});
