BEM.decl('i-searchable', {

    onSetMod: {

        js: function() {
            this.items = this.params.items;
        }

    },

    chunkSize: 20,

    chunkTimeout: 20,

    items: null,

    search: function(query, callback) {
        this.stopSearch();

        var iterator = this.createIterator(query, callback);

        this.trigger('search.start', {
            iterator: iterator
        });
        this.filterChunk.call(this, iterator);
    },

    stopSearch: function() {
        if (this._searchTimer) {
            clearTimeout(this._searchTimer);
            this._searchTimer = false;
        }
    },

    matchRow: function(row, iterator) {
        return false;
    },

    createIterator: function(query, callback) {
        return {
            query: query,
            iteration: 0,
            found: 0,
            visible: [],
            hidden: [],
            visibleMap: {},
            regexp: new RegExp('(' + query.text.replace(/(.)/g, function(s) {
                return '[' + (s == '\\' ? '\\\\' : s) + ']';
            }) + ')', 'i'),
            empty: !query.text.match(/\S/),
            callback: callback
        };
    },

    filterChunk: function(iterator) {
        var filtered = 0,
            foundInChunk = [],
            _this = this,
            item,
            callFilterChunk = function() {
                _this.filterChunk.call(_this, iterator)
            };

        while (iterator.iteration < this.items.length) {
            if (filtered == this.chunkSize) {
                foundInChunk.length && this.trigger('search.foundInChunk', {
                    foundInChunk: foundInChunk
                });

                this._searchTimer = setTimeout(callFilterChunk, this.chunkTimeout);

                return;
            }

            item = this.items[iterator.iteration];

            if (this.matchRow(item, iterator)) {
                iterator .found++;
                foundInChunk.push(item);
                iterator.visible.push(iterator.iteration);
                iterator.visibleMap[iterator.iteration] = true;
                this.trigger('search.found', {
                    item: item,
                    iterator: iterator
                });
                iterator.callback && iterator.callback(item, iterator);
            } else {
                iterator.hidden.push(iterator.iteration);

                this.trigger('search.missed', {
                    item: item,
                    iterator: iterator
                });
            }

            iterator .iteration++;
            filtered++;
        }

        foundInChunk.length && this.trigger('search.foundInChunk', {
            foundInChunk: foundInChunk
        });

        this.stopSearch();
        this.trigger('search.finish', {
            iterator: iterator
        });
    },

    changeDescription: function(index, text) {
        this.items[index].desc = text.toLowerCase();
    },

    updateItems: function(items) {
        this.items = items.slice();
    }
});
