describe('i-smart-filters-manager', function() {
    var filtersManager,
        statesMap1 = {
            orderedFiltersNames: ['categoryId', 'id', 'url'],

            categoryId: {
                orderedSubFiltersNames: ['>','<','==','<->'],
                subFilters: {
                    '>': {},
                    '<': {},
                    '=': {},
                    '<->': {}
                }
            },
            id: {
                orderedSubFiltersNames: ['>','<','==','<->'],
                subFilters: {
                    '>': {},
                    '<': {},
                    '=': {},
                    '<->': {}
                }
            },
            url: {
                orderedSubFiltersNames: ['==','like','not like'],
                subFilters: {
                    '==': {},
                    'like': {},
                    'not like': {}
                }
            }

        };
    afterEach(function() {
        filtersManager.destruct();
    });

    describe('Проверка API', function() {
        beforeEach(function() {
            filtersManager = BEM.create('i-smart-filters-manager', {
                statesMap: statesMap1,
                filterName: 'field',
                subFilterName: 'relation'
            });
        });
    });

    describe('Проверяем работу метода updateAvailableHash', function() {
        beforeEach(function() {
            filtersManager = BEM.create('i-smart-filters-manager', {
                statesMap: statesMap1,
                filterName: 'field',
                subFilterName: 'relation'
            });
        });

        it('Добавили новый фильтр { filter: categoryId, subFilter: > }, Комбинация { filter: categoryId, subFilter: > } станет недоступной. Остальные сабфильтры останутся без изменений', function() {
            filtersManager.updateAvailableHash('add', { filter: 'categoryId', subFilter: '>'});

            expect(filtersManager.isSubFilterEnabled('categoryId', '>')).to.be.false;
            expect(filtersManager.isSubFilterEnabled('categoryId', '<')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '==')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '<->')).to.be.true;
        });

        it('Удалили фильтр { filter: categoryId, subFilter: > }. Комбинация { filter: categoryId, subFilter: > } станет доступной. Остальные сабфильтры без изменений', function() {
            filtersManager.updateAvailableHash('remove', { filter: 'categoryId', subFilter: '>'});

            expect(filtersManager.isSubFilterEnabled('categoryId', '>')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '<')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '==')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '<->')).to.be.true;
        });

        it('Изменили фильтр { filter: categoryId, subFilter: > } на { filter: categoryId, subFilter: < }. Итог { filter: categoryId, subFilter: < } - недоступна, { filter: categoryId, subFilter: > } доступна', function() {
            filtersManager.updateAvailableHash('change-sub-filter', { filter: 'categoryId', prevFilter: 'categoryId', prevSubFilter: '>', subFilter: '<' });

            expect(filtersManager.isSubFilterEnabled('categoryId', '>')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '<')).to.be.false;
            expect(filtersManager.isSubFilterEnabled('categoryId', '==')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('categoryId', '<->')).to.be.true;
        });

        it('Изменили фильтр { filter: categoryId, subFilter: > } на { filter: id, subFilter: > }. Итого: { filter: categoryId, subFilter: > } доступна,  { filter: id, subFilter: > } - недоступна ', function() {
            filtersManager.updateAvailableHash('change-filter', { filter: 'id', prevFilter: 'categoryId', prevSubFilter: '>', subFilter: '>' });

            expect(filtersManager.isSubFilterEnabled('categoryId', '>')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('id', '>')).to.be.false;
        });

        it('Изменили фильтр { filter: categoryId, subFilter: > } на { filter: url, subFilter: == }. Итого { filter: categoryId, subFilter: > } - доступен, { filter: url, subFilter: == } - недоступен', function() {
            filtersManager.updateAvailableHash('change-filter', { filter: 'url', prevFilter: 'categoryId', subFilter: '==', prevSubFilter: '>' });

            expect(filtersManager.isSubFilterEnabled('categoryId', '>')).to.be.true;
            expect(filtersManager.isSubFilterEnabled('url', '==')).to.be.false;
        });
    });

    describe('Проверяем работу метода getNewFilterData', function() {
        it('Доступные состояния: ' + JSON.stringify(statesMap1) + '. Должен вернуть ' + JSON.stringify({ filter: 'categoryId', relation: '>' }), function() {
            filtersManager = BEM.create('i-smart-filters-manager', {
                statesMap: statesMap1,
                filterName: 'field',
                subFilterName: 'relation'
            });

            expect(filtersManager.getNewFilterData()).to.eql({ field: 'categoryId', relation: '>' });
        });

        it('После добавления всех доступных сабфильтров для categoryId, должен вернуть ' + JSON.stringify({ filter: 'id', relation: '>' }), function() {
            filtersManager.getOrderedSubFiltersList('categoryId').forEach(function(relation) {
                filtersManager.updateAvailableHash('add', { filter: 'categoryId', subFilter: relation });
            });

            expect(filtersManager.getNewFilterData()).to.eql({ field: 'id', relation: '>' });
        })
    });

    describe('Проверяем работу метода getAdjustedNewFilterData', function() {
        before(function() {
            filtersManager = BEM.create('i-smart-filters-manager', {
                statesMap: statesMap1,
                filterName: 'field',
                subFilterName: 'relation'
            });
        });

        it('Вызываем getAdjustedNewFilterData со доступным и еще не выбранным значением для сабфильтра - значение не изменится', function() {
            expect(filtersManager.getAdjustedNewFilterData({ filter: 'categoryId', subFilter: '>' })).to.eql({ field: 'categoryId', relation: '>' });
        });

        it('Вызываем getAdjustedNewFilterData со доступным но уже выбранным значением для сабфильтра - сабфильтр изменится на еще не выбранный', function() {
            filtersManager.updateAvailableHash('add', { filter: 'categoryId', subFilter:  '>' });
            expect(filtersManager.getAdjustedNewFilterData({ filter: 'categoryId', subFilter: '>' })).to.eql({ field: 'categoryId', relation: '<' });
        });

        it('Вызываем getAdjustedNewFilterData со недоступным для данного фильтра значением для сабфильтра - сабфильтр изменится на первый доступный еще не выбранный', function() {
            filtersManager.updateAvailableHash('add', { filter: 'categoryId', subFilter:  '>' });
            expect(filtersManager.getAdjustedNewFilterData({ filter: 'categoryId', subFilter: 'like' })).to.eql({ field: 'categoryId', relation: '<' });
        })
    })

});
