(function() {
    var stacktrace = {};
    /*jshint -W054*/
    (new Function('borschik:include:../../node_modules/stacktrace-js/dist/stacktrace.concat.js')).call(stacktrace);

    BEM.decl('i-stack-trace', {

        onSetMod: {
            js: function() {
                this._stack = this.params.stack;
            }
        },

        /**
         * Выполненные строчки кода стектрейса
         * @param {Function} options.filterScript фильтр по url скрипта
         * @param {Function} options.linesBefore сколько строк добавлять перед выполненной
         * @param {Function} options.linesAfter сколько строк добавлять после выполненной
         * @returns {Promise}
         */
        traceSourceCode: function(options) {
            var _this = this,
                filterScript = options.filterScript || u._.identity,
                fragmentPromises = this._stack.reduce(function(fragmentPromises, stackItem) {
                    var scriptUrl = stackItem.fileName,
                        fragmentPromise;

                    if (scriptUrl && filterScript(scriptUrl)) {
                        fragmentPromise = _this._fetchScriptSource(scriptUrl)
                            .then(function() {
                                var lineNumber = stackItem.lineNumber,
                                    lines = _this._getScriptLines(
                                        scriptUrl,
                                        lineNumber - options.linesBefore,
                                        lineNumber + options.linesAfter);

                                return _this._formatLines(lines);
                            });
                        fragmentPromises.push(fragmentPromise);
                    }

                    return fragmentPromises;
                }, []);

            return $.when.apply($, fragmentPromises)
                .then(function() {
                    return Array.prototype.slice.call(arguments);
                });
        },

        /**
         * Форматирует строки кода, удаляя лишние пробелы в начале
         * @param {Array} lines массив строк
         * @returns {Array} массив отформатированных строк
         * @private
         */
        _formatLines: function(lines) {
            var spacesCountRegex = /\S|$/,
                // массив с количеством пробелов в каждой непустой строке
                startSpacesCount = lines
                    .filter(function(line) {
                        return line.length;
                    })
                    .map(function(line) {
                        return line.search(spacesCountRegex);
                    }),
                minSpacesCount = Math.min.apply(null, startSpacesCount);

            // в каждой строке удаляем по minSpacesCount символов в начале
            return lines.map(function(line) {
                return line.substring(minSpacesCount);
            });
        },

        /**
         * Возвращает фрагмент строк скрипта
         * @param {String} url путь к скрипту
         * @param {Number} startLine строка начала фрагмента
         * @param {Number} endLine строка конца
         * @returns {Array} массив строк скрипта
         * @private
         */
        _getScriptLines: function(url, startLine, endLine) {
            return this.__self._scriptUrlToSourceLines[url].slice(startLine - 1, endLine);
        },

        /**
         * Ajax запрос за содержимым скрипта
         * @param {String} url путь к скрипту
         * @returns {Promise}
         * @private
         */
        _fetchScriptSource: function(url) {
            var scriptUrlToPromise = this.__self._scriptUrlToPromise,
                scriptUrlToSourceLines = this.__self._scriptUrlToSourceLines,
                promise = scriptUrlToPromise[url];

            if (!promise) {
                promise = $.Deferred();
                scriptUrlToPromise[url] = promise;
                BEM.create('i-request_type_ajax', {
                    url: url,
                    type: 'GET',
                    contentType: false,
                    dataType: 'text'
                }).get(
                    {},
                    function(source) {
                        var sourceLines = source.split('\n');

                        scriptUrlToSourceLines[url] = sourceLines;
                        promise.resolve();
                    },
                    function() {
                        promise.reject();
                    }
                );
            }

            return promise;
        }

    }, {

        /**
         * Хэш url скрипта -> массив строчек кода
         */
        _scriptUrlToSourceLines: {},

        /**
         * Хэш url скрипта -> промис запроса за его контентом
         */
        _scriptUrlToPromise: {},

        /**
         * Получение инстанса i-stack-trace на основе переданной ошибки
         * @param {Error} error ошибка
         * @returns {i-stack-trace}
         */
        fromError: function(error) {
            var errorStackTrace = stacktrace.ErrorStackParser.parse(error);

            return BEM.create('i-stack-trace', {
                stack: errorStackTrace
            });
        }

    });
})()
