BEM.decl('i-switch-to-dna', {}, {

    /**
     * Переключает на интерфейс dna и обратно
     * @param {Boolean} value true - переключить на dna, false -обратно
     */
    doSwitch: function(value) {
        var _this = this;

        BEM.blocks['i-web-api-request'].feature.setState([
            {
                feature: 'grid',
                enabled: value
            }
        ]).then(function(response) {
            if (response.success === true) {
                if (value === false) {
                    window.location = u.getUrl('showCamps', { ulogin: u.consts('ulogin') });
                } else {
                    // если включаем новый интерфейс, то на гриды попадем, потому что на бекэнде написан редирект с showCamps
                    window.location.reload();
                }
            } else {
                _this._onError();
            }
        }, function() {
            _this._onError();
        });
    },

    /**
     * Показывает попап с ошибкой
     * @private
     */
    _onError: function() {
        BEM.blocks['b-user-dialog'].alert(
            iget2('i-switch-to-dna', 'interface-switch-error', 'Произошла ошибка при переключении интерфейса. Попробуйте ещё раз.')
        );
    }

});
