(function() {
    u.tv4.addFormat({
        'json-string': function(data, schema) {
            var jsonObject,
                res;

            if (typeof data === 'string') {
                try {
                    jsonObject = JSON.parse(data);
                } catch (e) {
                    return 'must be valid json';
                }

                res = u.tv4.validateMultiple(jsonObject, schema.json);

                return res.valid ?
                    null :
                    res.errors.map(function(error) {
                        return error.message;
                    }).join(', ');
            }

            return 'must be valid json';
        }
    });
})();
