(function() {
    u.tv4.addFormat({
        'one-of-custom': function(data, schema) {
            var isValid = false,
                currRes,
                resArray;

            if (schema.items && schema.items.length) {
                resArray = schema.items.map(function(currSchema) {
                    currRes = u.tv4.validateMultiple(data, currSchema);

                    if (currRes.valid) {
                        isValid = true;
                    } else {
                        return '<br/>' + currSchema.description + ':: ' +
                            currRes.errors.reduce(function(resStr, err) {
                                return (resStr ? resStr + ', ' : '') + err.message;
                            }, '');
                    }
                }, this);
                return isValid ?
                    null :
                    resArray.join('');
            }

            return 'schema must contain valid parts of one-of-custom object';
        }
    });
})();
