/**
 * Проверка поддержки браузером чего-либо
 */
BEM.decl('i-ua', {}, {

    /**
     * Метод проверки, результат кешируется
     * @static
     * @param {String} what Что проверяем
     */
    check: function(what) {
        var fn = this._support[what];

        if (typeof fn !== 'undefined') {
            return typeof fn === 'function' ?
                    (fn.hasOwnProperty('result') ? fn.result : (fn.result = fn())) :
                    fn;
        }

        return false;
    },

    /**
     * @private
     * @static
     * @type {Object}
     */
    _support: {

        /**
         * Проверяет поддерживает ли броузер работу с канвасом
         * @returns {Boolean}
         */
        canvas: function() {
            var elem = document.createElement('canvas');

            return Boolean(elem.getContext && elem.getContext('2d'));
        },

        /**
         * Проверяет, поддерживает ли броузера CSS transform, возвращает название свойства либо false;
         * @returns {String|Boolean}
         */
        transform: function() {
            var div = document.createElement('div'),
                properties = ['transform', 'WebkitTransform', 'MozTransform', 'msTransform', 'OTransform'],
                i = properties.length;

            while (i--) {
                if (typeof div.style[properties[i]] !== 'undefined') {
                    return properties[i];
                }
            }

            return false;
        },

        /**
         * Проверяет, поддерживает ли броузер CSS transition
         * @returns {Boolean}
         */
        transition: function() {
            var div = document.createElement('div'),
                properties = ['transition', 'WebkitTransition', 'MozTransition', 'MsTransition', 'OTransition'],
                i = properties.length,
                style;

            try {
                div.innerHTML = '<div style="-webkit-transition:left 1s linear;' +
                            '-moz-transition:left 1s linear;-o-transition:left 1s linear;"></div>';

                style = div.firstChild.style;

                while (i--) {
                    if (typeof style[properties[i]] !== 'undefined') {
                        return properties[i];
                    }
                }
            } catch (e) {}

            return false;
        },

        /**
         * Проверяет, поддерживает ли броузер svg
         * @returns {Boolean}
         */
        svg: function() {
            return Boolean(window.SVGAngle);
        },

        /**
         * Проверяет, поддерживает ли броузер vml
         * @returns {Boolean}
         */
        vml: function() {
            var a = document.body.appendChild(document.createElement('div')),
                b,
                ret;

            a.innerHTML = '<v:shape id="vml_flag1" adj="1" />';
            b = a.firstChild;
            b.style.behavior = 'url(#default#VML)';
            ret = b ? typeof b.adj === 'object' : true;
            a.parentNode.removeChild(a);

            return ret;
        },

        /**
         * Проверяет, поддерживает ли броузер history api
         * @type {Boolean}
         */
        history: Boolean(window.history && window.history.pushState)

    }

});
