describe('i-unload-warning', function() {

    var unloadWarning = BEM.blocks['i-unload-warning'],
        winMock = {
            addEventListener: function(eName, fn) {
                winMock.unloadListener = fn;
            }
        };

    afterEach(function() {
        unloadWarning.removeChecker();
    });

    it('Должен вызывать чекер при уходе со страницы', function() {
        var checker = sinon.spy();

        unloadWarning.addChecker(checker, {}, winMock);
        winMock.unloadListener();

        expect(checker.called).to.be.equal(true);
    });

    it('Обработчик должен возвращать undefined, если чекер возвращает false', function() {
        unloadWarning.addChecker(function() { return false }, {}, winMock);
        expect((typeof winMock.unloadListener())).to.be.eql('undefined');
    });

    it('Обработчик должен возвращать строку которую вернул чекер', function() {
        var message = 'Привет мир!';

        unloadWarning.addChecker(function() { return message }, {}, winMock);
        expect(winMock.unloadListener()).to.be.equal(message);
    });

    it('Обработчик должен возвращать конкатенацию строк через "\\n\\n", которые вернули чекеры', function() {
        var message = 'Земля прощай!',
            message2 = 'В добрый путь!';

        unloadWarning
            .addChecker(function() { return message }, {}, winMock)
            .addChecker(function() { return message2 }, {}, winMock);
        expect(winMock.unloadListener()).to.be.equal(message + '\n\n' + message2);
    });

    it('Обработчик не должен включать в текст не строки', function() {
        var message = 'Земля прощай!',
            message2 = 'В добрый путь!';

        unloadWarning
            .addChecker(function() { return message }, {}, winMock)
            .addChecker(function() { return { t: 'just onject' } }, {}, winMock)
            .addChecker(function() { return message2 }, {}, winMock);
        expect(winMock.unloadListener()).to.be.equal(message + '\n\n' + message2);
    });
});
