describe('i-utils__auction', function() {
    var sandbox;

    before(function() {
        sandbox = sinon.sandbox.create();
        var constStub = u.stubCurrencies2(sandbox);

        constStub.withArgs('PRICE_PLACES').returns(window.CONSTS.PRICE_PLACES);
        constStub.withArgs('ENTRY_PLACES').returns(window.CONSTS.ENTRY_PLACES);
        constStub.withArgs('BSAUCTION_PLACE_LAYOUT').returns(window.CONSTS.BSAUCTION_PLACE_LAYOUT);
    });

    after(function() {
        sandbox.restore();
    });

    describe('Получение ставки аукциона по названию позиции', function() {
        var auctionData = {
            premium: [
                { bid_price: 1300 },
                { bid_price: 1200 },
                { bid_price: 1100 },
                { bid_price: 1000 },
            ],
            guarantee: [
                { bid_price: 2300 },
                { bid_price: 2200 },
                { bid_price: 2100 },
                { bid_price: 2000 },
            ],
        };
        var expectedPrices = {
            pmax: 1300,
            pmax2: 1200,
            pmin: 1000,
            max: 2300,
            min: 2000,
        };

        ['pmax', 'pmax2', 'pmin', 'max', 'min'].forEach(function(name) {
            it('Получение ставки по на позиции ' + name, function() {
                expect(u.auction.getDataByPlace(auctionData, name).bid_price).to.be.equal(expectedPrices[name]);
            });
        });
    });

});
