u.register({
    auction: {

        /**
         *
         * @param {Object} auctionData
         * @param {Object} auctionData.premium массив со ставками в спецразмещении
         * @param {Object} auctionData.guarantee массив со ставками в гарантии
         * @param {String} place название позиции (pmax|pmax2|pmin|max|min)
         * @returns {Object} элемент массива auctionData.premium или auctionData.guarantee, в зависимости от place
         */
        getDataByPlace: function(auctionData, place) {
            var BSAUCTION_PLACE_LAYOUT = u.consts('BSAUCTION_PLACE_LAYOUT'),
                PRICE_PLACES = u.consts('PRICE_PLACES'),
                ENTRY_PLACES = u.consts('ENTRY_PLACES'),
                placeInfoMap = {
                    pmax: BSAUCTION_PLACE_LAYOUT[PRICE_PLACES.PREMIUM1],
                    pmax2: BSAUCTION_PLACE_LAYOUT[PRICE_PLACES.PREMIUM2],
                    pmin: BSAUCTION_PLACE_LAYOUT[ENTRY_PLACES.PREMIUM],
                    max: BSAUCTION_PLACE_LAYOUT[PRICE_PLACES.GUARANTEE1],
                    min: BSAUCTION_PLACE_LAYOUT[ENTRY_PLACES.GUARANTEE],
                    mcbanner: BSAUCTION_PLACE_LAYOUT[PRICE_PLACES.GUARANTEE1],
                },
                placeInfo = placeInfoMap[place];

            if (!placeInfo || !auctionData[placeInfo.type]) {
                return undefined;
            }

            return auctionData[placeInfo.type][placeInfo.index];
        }
    }
});
