describe('i-utils__autobroker', function() {
    var sandbox;

    before(function() {
        sandbox = sinon.sandbox.create();
        var constStub = u.stubCurrencies2(sandbox);

        constStub.withArgs('PRICE_PLACES').returns(window.CONSTS.PRICE_PLACES);
        constStub.withArgs('ENTRY_PLACES').returns(window.CONSTS.ENTRY_PLACES);
        constStub.withArgs('BSAUCTION_PLACE_LAYOUT').returns(window.CONSTS.BSAUCTION_PLACE_LAYOUT);
    });

    after(function() {
        sandbox.restore();
    });

    describe('.calcPrice', function() {
        var PLACES = u.consts('PRICE_PLACES'),
            premium = [
                { bid_price: 780000, amnesty_price: 780000 },
                { bid_price: 710000, amnesty_price: 710000 },
                { bid_price: 610000, amnesty_price: 610000 },
                { bid_price: 510000, amnesty_price: 510000 }
            ],
            guarantee = [
                { bid_price: 110000, amnesty_price: 110000 },
                { bid_price: 100000, amnesty_price: 100000 },
                { bid_price: 40000, amnesty_price: 40000 },
                { bid_price: 30000, amnesty_price: 30000 }
            ],
            premiumLessThenGuarantee = [
                { bid_price: 100000, amnesty_price: 100000 },
                { bid_price: 100000, amnesty_price: 100000 },
                { bid_price: 100000, amnesty_price: 100000 },
                { bid_price: 100000, amnesty_price: 100000 }
            ],
            larr = 20000,

            premiumRub = [
                { bid_price: 21300000, amnesty_price: 21300000 },
                { bid_price: 16300000, amnesty_price: 16300000 },
                { bid_price: 11300000, amnesty_price: 11300000 },
                { bid_price: 6300000, amnesty_price: 6300000 }
            ],
            guaranteeRub = [
                { bid_price: 3300000, amnesty_price: 3300000 },
                { bid_price: 3000000, amnesty_price: 3000000 },
                { bid_price: 1200000, amnesty_price: 1200000 },
                { bid_price: 900000, amnesty_price: 900000 }
            ],
            larrRub = 6000000;

        [
            {
                description: 'Гарантия просто',
                funcArgs: {
                    price: 0.03,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'СР c коэффициентом цены по временному таргетингу (100%)',
                funcArgs: {
                    price: 0.8,
                    timetargetingCoef: 100,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.78,
                    truncated: 0,
                    placeName: PLACES.PREMIUM1,
                    placeNameWithoutCoef: PLACES.PREMIUM1
                }
            },
            {
                description: 'Гарантия c коэффициентом цены по временному таргетингу (10%) (без коэф - спецразмещение)',
                funcArgs: {
                    price: 0.8,
                    timetargetingCoef: 10,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.PREMIUM1
                }
            },
            {
                description: 'ограниченная остатком денег на кампании',
                funcArgs: {
                    price: 0.11,
                    campRest: 0.04,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 1,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'ограниченная дневным бюджетом',
                funcArgs: {
                    price: 0.11,
                    dayBudget: 0.04,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 1,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'ограниченная неистраченной суммой дневного бюджета',
                funcArgs: {
                    price: 0.11,
                    dayBudget: 10,
                    spentToday: 9.97,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 1,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'ограниченная неистраченной суммой дневного бюджета на кампании без денег',
                funcArgs: {
                    campRest: 0,
                    price: 0.11,
                    dayBudget: 10,
                    spentToday: 9.97,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 1,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'кампания без денег',
                funcArgs: {
                    campRest: 0,
                    price: 0.11,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.11,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE1,
                    placeNameWithoutCoef: PLACES.GUARANTEE1
                }
            },
            {
                description: 'Гарантия с установленной стратегией "по минимальной цене"',
                funcArgs: {
                    price: 0.04,
                    strategy: { search: { name: 'min_price' } },
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'Garantee with min price strategy-2',  //todo
                funcArgs: {
                    price: 0.04,
                    strategy: { search: { name: 'min_price', place: 'both' } },
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'Garantee with min price strategy-3',
                funcArgs: {
                    price: 0.04,
                    strategy: { search: { name: 'min_price', place: 'premium' } },
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'спецразмещение просто',
                funcArgs: {
                    price: 0.8,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.78,
                    truncated: 0,
                    placeName: PLACES.PREMIUM1,
                    placeNameWithoutCoef: PLACES.PREMIUM1
                }
            },
            {
                description: 'untruncated Premium',
                funcArgs: {
                    price: 0.8,
                    campRest: 0.81,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.78,
                    truncated: 0,
                    placeName: PLACES.PREMIUM1,
                    placeNameWithoutCoef: PLACES.PREMIUM1
                }
            },
            {
                description: 'Случаи "Гарантия дороже СР"',
                funcArgs: {
                    price: 0.8,
                    premium: premiumLessThenGuarantee,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.10,
                    truncated: 0,
                    placeName: PLACES.PREMIUM1,
                    placeNameWithoutCoef: PLACES.PREMIUM1
                }
            },
            {
                description: 'по минимальной цене в блоке гарантия; хватает на 1-е место, но не выбираем его',
                funcArgs: {
                    price: 0.05,
                    strategy: { search: { name: 'min_price', place: 'both' } },
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'truncated Premium < Gar',
                funcArgs: {
                    price: 0.8,
                    campRest: 0.1,
                    premium: premiumLessThenGuarantee,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.1,
                    truncated: 0,
                    placeName: PLACES.PREMIUM1,
                    placeNameWithoutCoef: PLACES.PREMIUM1
                }
            },
            {
                description: 'Случаи с ограничением мин. цены на поиске',
                funcArgs: {
                    price: 0.01,
                    minPrice: 0.02,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0,
                    truncated: 0,
                    placeName: PLACES.ROTATION,
                    placeNameWithoutCoef: PLACES.ROTATION
                }
            },
            {
                description: 'Zero min price',
                funcArgs: {
                    price: 0.01,
                    minPrice: 0,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0,
                    truncated: 0,
                    placeName: PLACES.ROTATION,
                    placeNameWithoutCoef: PLACES.ROTATION
                }
            },
            {
                description: 'Обычный автобюджет',
                funcArgs: {
                    autobudget: 'Yes',
                    autobudgetBid: 5,
                    price: 0.04,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'Автобюджет, ограниченный минимальной ставкой',
                funcArgs: {
                    autobudget: 'Yes',
                    autobudgetBid: 0.04,
                    price: 20,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'Автобюджет, ограниченный минимальной ставкой и остатком на кампании',
                funcArgs: {
                    autobudget: 'Yes',
                    autobudgetBid: 0.11,
                    price: 20,
                    campRest: 0.04,
                    premium: premium,
                    guarantee: guarantee,
                    larr: larr
                },
                expectedResult: {
                    price: 0.03,
                    truncated: 1,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'Гарантия в рублях',
                funcArgs: {
                    price: 1.5,
                    currency: 'RUB',
                    premium: premiumRub,
                    guarantee: guaranteeRub,
                    larr: larrRub
                },
                expectedResult: {
                    price: 0.9,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE4,
                    placeNameWithoutCoef: PLACES.GUARANTEE4
                }
            },
            {
                description: 'Округление до шага торгов ставки, ограниченной дневным бюджетом',
                funcArgs: {
                    price: 5,
                    currency: 'KZT',
                    dayBudget: 4.98,
                    premium: premiumRub,
                    guarantee: guaranteeRub,
                    larr: larrRub
                },
                expectedResult: {
                    price: 3.00,
                    truncated: 0,
                    placeName: PLACES.GUARANTEE1,
                    placeNameWithoutCoef: PLACES.GUARANTEE1
                }
            }
        ].forEach(function(testData) {
            it(testData.description, function() {
                expect(u.autobroker.calcPrice(testData.funcArgs)).to.be.eql(testData.expectedResult);
            });
        });

    });
});
