block('i-utils').match(function() {
    return this.utilsElem;
}).def()(function() {
    var data = this.data,
        loginRights = data.login_rights || {};

    /**
     * Определяет доступность автоплатежа для пользователя
     * @returns {Boolean}
     */
    function isDisabled() {
        var wallet = data.wallet || {},
            allowPay = (wallet.self || wallet).allow_pay;

        // недоступно ограниченным представителям у которых нет возможности выставления счета
        return (loginRights['is_agency_limited'] && loginRights['agency_limited_no_pay']) ||
            // если у данного клиента не стоит галка allow_pay
            !allowPay;
    }

    u.register({
        autopayment: {
            params: {
                // доступность автоплатежа для пользователя
                disabled: !!isDisabled(),
                // возможность возобновлять автополнение
                canResumeAutopay: !!(loginRights.role == 'client' || loginRights['super_control']),
                // возможность изменения настроек автополнения
                disableEditAutopay: !!(loginRights['placer_control'] || loginRights['media_control'] || data.is_mcc_control)
            }
        }
    });

    return applyNext();
});
