describe('i-utils__banner-data', function() {
    it('Если banner: { bid: 124 } => isNewBanner = false', function() {
        var banner = u.bannerData({ banner: { bid: 124 } });

        expect(banner.isNewBanner).to.be.equal(false);
    });

    it('Если banner: { bid: "0" } => isNewBanner = true', function() {
        var banner = u.bannerData({ banner: { bid: '0' } });

        expect(banner.isNewBanner).to.be.equal(true);
    });


    it('Если banner: { bid: undefined } => isNewBanner = true', function() {
        var banner = u.bannerData({ banner: { bid: undefined } });

        expect(banner.isNewBanner).to.be.equal(true);
    });

    it('Если banner: {  } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: {} });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });

    it('Если banner: { vcard_id: "0" } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: { vcard_id: '0'} });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });

    it('Если banner: { href: bla } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: { href: 'bla' } });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });

    it('Если banner: { vcard: { city: null, country: undefined }  } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: { vcard: { city: null, country: undefined } } });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });

    it('Если banner: { vcard_id: 11  } => has_vcard = 1, is_vcard_open = true', function() {
        var banner = u.bannerData({ banner: { vcard_id: 11 } });
        expect(banner.has_vcard).to.be.equal(1);
        expect(banner.is_vcard_open).to.be.equal(true);
    });

    it('Если banner: { phone: 11  } => has_vcard = 1, is_vcard_open = true', function() {
        var banner = u.bannerData({ banner: { phone: 11 } });
        expect(banner.has_vcard).to.be.equal(1);
        expect(banner.is_vcard_open).to.be.equal(true);
    });


    it('Если banner: { href: bla, vcard: { vcard_id: 100 } } => has_href = 1, has_vcard = 1, is_vcard_open = true', function() {
        var banner = u.bannerData({ banner: { href: 'bla', vcard: { vcard_id: 100 } } });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(1);
        expect(banner.is_vcard_open).to.be.equal(true);
    });

    it('Если banner: { vcard: { vcard_id: 100 } } => has_href = 0, has_vcard = 1, is_vcard_open = true', function() {
        var banner = u.bannerData({ banner: { vcard: { vcard_id: 100 } } });

        expect(banner.has_href).to.be.equal(0);
        expect(banner.has_vcard).to.be.equal(1);
        expect(banner.is_vcard_open).to.be.equal(true);
    });

    it('Если banner: { vcard: { vcard_id: 100 }, has_vcard: 0 } => has_href = 0, has_vcard = 1, is_vcard_open = true', function() {
        var banner = u.bannerData({ banner: { vcard: { vcard_id: 100 }, has_vcard: 0  } });

        expect(banner.has_href).to.be.equal(0);
        expect(banner.has_vcard).to.be.equal(1);
        expect(banner.is_vcard_open).to.be.equal(true);
    });

    it('Если banner: { href: bla, has_href: 0 } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: { href: 'bla', has_href: 0 } });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });


    it('Если banner: { has_vcard: 1, has_href: 1 } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: { href: 'bla', has_href: 0 } });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });

    it('Если banner:{ banner: { newBanner: true, href: bla }, ci_hidden: 0, has_accepted_vcard: 1 } => has_href = 1, has_vcard = 0, is_vcard_open = false', function() {
        var banner = u.bannerData({ banner: { newBanner: 1, href: 'bla' }, ci_hidden: 0, has_accepted_vcard: 1 });

        expect(banner.has_href).to.be.equal(1);
        expect(banner.has_vcard).to.be.equal(0);
        expect(banner.is_vcard_open).to.be.equal(false);
    });

    it('Если banner:{ } => is_vcard_collapsed = false', function() {
        var banner = u.bannerData({ banner: {  } });

        expect(banner.is_vcard_collapsed).to.be.equal(false);
    });

    it('Если banner: { is_vcard_collapsed: true } => is_vcard_collapsed = true', function() {
        var banner = u.bannerData({ banner: { is_vcard_collapsed: true  } });

        expect(banner.is_vcard_collapsed).to.be.equal(true);
    });

});
