u.register({
    bannerData: function(options) {
        var banner = options.banner,
            isMetroDeleted,
            isFirstLoad = options.isFirstLoad,
            value;

        banner.bid = +banner.bid;
        banner.isNewBanner = !banner.bid;

        //если не отфильтровать, то u._.isEmpty выдаст false на пустой визитке - DIRECT-39563
        if (banner.vcard) {
            Object.keys(banner.vcard).forEach(function(name) {
                value = banner.vcard[name];
                if (name === 'metro' && banner.vcard[name] === null) isMetroDeleted = true;
                if (value === null || value === undefined) delete banner.vcard[name];
            });
            //DIRECT-40940 - для metro null это осмысленное значение, присылаемое сервером, его надо хранить, если визитка не пуста
            if (!u._.isEmpty(banner.vcard) && isMetroDeleted) banner.vcard.metro = null;
        }

        banner.vcard_id = +banner.vcard_id;

        if (typeof banner.isVCardEmpty === 'undefined') {
            // на поиске по баннерам есть banner.phone, но нет banner.vcard_id
            banner.isVCardEmpty = !banner.vcard_id && !banner.phone && u._.isEmpty(banner.vcard);
        }

        banner.has_vcard = banner.isVCardEmpty ? 0 : 1;

        if (isFirstLoad) {
            banner.is_vcard_open = Number(banner.has_vcard) === 1 ?
                true :
                //DIRECT-26904 - логика открытия визитки для нового баннера
                //Пустая визитка показывается открытой только если у пользователя
                // НЕТ промодерированных визиток И пользователь НЕ закрывал вручную пустую
                (!banner.isNewBanner ?
                    false :
                    Number(options.ci_hidden) === 1 || Number(options.has_accepted_vcard) !== 1);
        } else {
            //Если мы вернулись на страницу создания баннера со 2-го шага или вернулись с ошибкой сложный алгоритм не нужен
            banner.is_vcard_open = Number(banner.has_vcard) === 1;
        }

        banner.has_href = banner.href ? 1 : 0;

        if (!banner.has_href && !banner.has_vcard) {
            banner.has_href = 1;
        }

        banner.is_vcard_collapsed = banner.is_vcard_collapsed === undefined ? false : banner.is_vcard_collapsed;

        if (banner.measurers) {
            banner.measurers.forEach(function(measurer) {
                banner = u.measurers.applyEnabledModelData(banner, measurer);
            });
        }

        return banner;
    }
});
