describe('i-utils__banner-model-data', function() {
    var fieldsNeedToCopy = [
        'cid',
        'vcard_id',
        'age',
        'archive',
        'BannerID',
        'bid',
        'canToggleAge',
        'adgroup_id',
        'autobudget',
        'showAdminAttrs',
        'showAdvEditAlert',
        'status',
        'isStatusOptimized',
        'statusAutobudgetShow',
        'isRejectByModerator',
        'statusShow',
        'groupStatusModerate',
        'statusModerate',
        'statusActive',
        'title',
        'body',
        'display_href',
        'domain',
        'domain_sign',
        'domain_redir',
        'domain_redir_sign',
        'image',
        'image_name',
        'image_type',
        'image_width',
        'image_height',
        'source_image',
        'image_source_url',
        'vcard',
        'isVCardEmpty',
        'is_vcard_open',
        'has_href',
        'has_vcard',
        'declined_show',
        'child_age',
        'baby_food_enabled',
        'enable',
        'statusOpenStat',
        'fio',
        'email',
        'tags',
        'url_protocol',
        'splited_phrases',
        'showAgeLabels',
        'hasCopyFromPrev',
        'isArchived',
        'newBannerIndex',
        'isNewBanner',
        'modelId',
        'is_vcard_collapsed',
        //имя группы, к которой принадлежит баннер DIRECT-38629
        'group_name',
        'is_bs_rarely_loaded'
    ],
    fullTestBanner,
    bannerModelData;

    beforeEach(function() {
        fullTestBanner = fieldsNeedToCopy.reduce(function(data, name) {
                data[name] = 'bla';

                return data;
            }, {});

        bannerModelData = u.bannerModelData({ banner: fullTestBanner });
    });

    fieldsNeedToCopy.forEach(function(name) {
        it('Поле ' + name + ' должно быть в данных модели, если в баннере оно заполнено', function() {
            expect(bannerModelData[name]).not.to.be.empty;
        });
    });

    it('Поле image_model должно быть в данных модели, если в баннере оно заполнено', function() {
        expect(bannerModelData.image_model).to.be.an.instanceof(Object);
    });

    ['modelId', 'image', 'image_name', 'image_type', 'source_image', 'image_source_url', 'image_width', 'image_height'].forEach(function(name) {
        it('Поле image_model должно содержать: ' + name, function() {
            expect(bannerModelData.image_model).to.have.property(name);
        });
    });

    it('Поле href_model должно быть в данных модели, если в баннере оно заполнено', function() {
        expect(bannerModelData.href_model).to.be.an.instanceof(Object);
    });

    ['modelId', 'isParentBannerNew', 'href', 'url_protocol', 'domain', 'domain_ascii',
        'domain_redir', 'domain_redir_sign', 'domain_sign', 'domain_error'
    ].forEach(function(name) {
        it('Поле href_model должно содержать: ' + name, function() {
            expect(bannerModelData.href_model).to.have.property(name);
        });
    });

    it('Если не пришло isVCardEmpty, но пришло vcard_id или vcard надо установить флаг has_vcard = 1 и isVCardEmpty = false', function() {
        var testBanner2 = $.extend({}, fullTestBanner),
            bannerModelData2;

        delete testBanner2.isVCardEmpty;
        delete testBanner2.is_vcard_open;
        delete testBanner2.has_vcard;

        bannerModelData2 = u.bannerModelData({ banner: testBanner2 });

        expect(bannerModelData2.has_vcard).to.be.equal(1);
        expect(bannerModelData2.isVCardEmpty).to.be.equal(false);
        expect(bannerModelData2.is_vcard_open).to.be.equal(true);
    });

    describe('Должен содержать заполненные сайтлинки если они пришли в данных', function() {
        var sitelinksData = [
                {
                    href: "ya.ru?q=1",
                    url_protocol: "http: //",
                    title: 'title',
                    description: 'description'
                },
                {
                    href: "ya.ru?q=2",
                    url_protocol: "http: //",
                    title: 'title2',
                    description: 'description2'
                }
            ],
            bannerModelData2,
            sitelinks;

        beforeEach(function() {
            fullTestBanner.sitelinks = sitelinksData;
            bannerModelData2 = u.bannerModelData({ banner: fullTestBanner });

            sitelinks = bannerModelData2.sitelinks;
        });



        sitelinksData.forEach(function(data, i) {
            Object.keys(data).forEach(function(field) {
                it('Должен содержать заполненные поле ' + field, function() {
                    expect(sitelinks[field + i]).to.be.equal(data[field]);
                });
            });
        });
    });
});
