(function() {
    u.register({
        bannerModelData: function(options) {
            var banner = options.banner,
                group = options.group || {},
                sitelinks = banner.sitelinks,
                data = [
                    'cid',
                    'vcard_id',
                    'age',
                    'archive',
                    'BannerID',
                    'bid',
                    'canToggleAge',
                    'adgroup_id',
                    'autobudget',
                    'showAdminAttrs',
                    'showAdvEditAlert',
                    'status',
                    'isStatusOptimized',
                    'statusAutobudgetShow',
                    'isRejectByModerator',
                    'statusShow',
                    'groupStatusModerate',
                    'statusBsSynced',
                    'statusModerate',
                    'statusActive',
                    'title',
                    'title_extension',
                    'body',
                    'content_promotion_content_type',
                    'content_promotion_visit_url',
                    'content_promotion_url',
                    'content_promotion_content_id',
                    'content_promotion_preview_url',
                    'display_href',
                    'domain',
                    'domain_sign',
                    'domain_redir',
                    'domain_redir_sign',
                    'image',
                    'image_name',
                    'image_type',
                    'image_width',
                    'image_height',
                    'lang',
                    'source_image',
                    'image_source_url',
                    'vcard',
                    'isVCardEmpty',
                    'is_vcard_open',
                    'has_href',
                    'has_href_only',
                    'has_site_enum',
                    'has_site',
                    'has_vcard',
                    'declined_show',
                    'child_age',
                    'baby_food_enabled',
                    'enable',
                    'statusOpenStat',
                    'fio',
                    'email',
                    'tags',
                    'url_protocol',
                    'splited_phrases',
                    'is_bs_rarely_loaded',
                    'showAgeLabels',
                    'hasCopyFromPrev',
                    'newBannerIndex',
                    'isNewBanner',
                    'modelId',
                    'is_vcard_collapsed',
                    //строить визитку на основании данных с клиента
                    'loadVCardFromClient',
                    //имя группы, к которой принадлежит баннер DIRECT-38629
                    'group_name',
                    //тип баннера - мобильный или десктопный
                    'banner_type',
                    'callouts',
                    'disclaimer', // предупреждения - текст
                    'hash_flags', // предупреждения
                    'status_click_track',
                    'isArchived',
                    // возможность удаление баннера
                    'can_delete_banner',
                    // объект изображения для графических объявлений
                    // image_ad.hash - хэш изображения
                    // image_ad.width
                    // image_ad.height
                    'image_ad',
                    // объект для отображения конструктора креативов
                    'creative',
                    // тип баннера text|image_ad
                    'ad_type',
                    // данные медиа дополнений для баннера
                    'video_resources',
                    'disable_videomotion',
                    // турбостраницы
                    'turbolanding',
                    'turbolandingGeoproduct',
                    'turbolanding_href_params',
                    // Пиксель Я.Аудиторий
                    'audience',
                    // Счётчик показов
                    'audits',
                    // Нужно для b-banner-status
                    // дневной бюджет
                    'day_budget',
                    'day_budget_show_mode',
                    // дневной бюджет на основной счет
                    'wallet_day_budget',
                    'wallet_day_budget_show_mode',
                    'banner_price',
                    'permalink',
                    'tns_id',
                    'placement_pages'
                ].reduce(function(data, name) {
                    if (banner[name] !== undefined) {
                        data[name] = banner[name];
                    }

                    return data;
                }, {
                    geo: banner.geo
                }),
                sitelinkHref;

            if (banner.measurers) {
                banner.measurers.forEach(function(measurer) {
                    data = u.measurers.prepareDataFromModel(data, banner, measurer);
                });
            }

            data.sitelinks = {};
            data = prepareDataFromAjax(data);

            for (var i = 0, n = sitelinks && sitelinks.length; i < n; i++) {
                sitelinkHref = sitelinks[i].href;
                data.sitelinks['title' + i] = sitelinks[i].title;
                data.sitelinks['href' + i] = sitelinkHref;
                data.sitelinks['url_protocol' + i] = sitelinks[i].url_protocol ||
                    u.parseUrl(sitelinkHref).protocol || 'https';
                data.sitelinks['description' + i] = sitelinks[i].description;
                data.sitelinks['turbolanding' + i] = sitelinks[i].turbolanding;
            }

            data.age = banner.age || banner.hash_flags && banner.hash_flags.age;

            data.adgroup_id = data.adgroup_id || group.adgroup_id;

            if (data.vcard && data.vcard.vcard_id && banner.modelId) {
                data.vcard.modelId = banner.modelId;
            }

            data.image_model = {
                modelId: banner.modelId,
                image: banner.image,
                image_name: banner.image_name,
                image_type: banner.image_type,
                source_image: banner.source_image,
                image_source_url: banner.image_source_url,
                mds_group_id: banner.mds_group_id,
                image_width: banner.image_width,
                image_height: banner.image_height
            };

            data.href_model = {
                modelId: banner.modelId,
                isParentBannerNew: banner.isNewBanner,
                href: banner.href,
                url_protocol: banner.url_protocol,
                domain: banner.domain,
                domain_ascii: banner.domain_ascii,
                domain_redir: banner.domain_redir,
                domain_redir_sign: banner.domain_redir_sign,
                domain_sign: banner.domain_sign,
                domain_error: banner.domain_error,
                market_rating: banner.market_rating
            };

            //в динамических объявлениях выставляем domain и href_model из данных группы
            if (group.adgroup_type === 'dynamic') {
                data.title = u.dynamicGroupsData.getBannerTitle();

                data.domain = group.main_domain;

                data.href_model = {
                    modelId: banner.modelId,
                    isParentBannerNew: banner.isNewBanner,
                    href: group.main_domain,
                    url_protocol: 'http://',
                    domain: group.main_domain
                };
            }

            data.loadVCardFromClient = data.loadVCardFromClient || options.loadVCardFromClient;

            // заголовок и текст объявления до автоисправления в модерации и флаг показа
            if (banner.before_moderation) {
                data.before_moderation =
                    u._.pick(banner.before_moderation, ['title', 'body', 'showModEditNotice', 'edit_createtime']);

                if (group.adgroup_type === 'dynamic') {
                    data.before_moderation.title = u.dynamicGroupsData.getBannerTitle();
                }
            }

            if (data.ad_type === 'cpm_banner') {
                data.placement_pages = (data.placement_pages || []).map(function(page) {
                    return {
                        id: page.page_id,
                        statusModerate: page.status_moderate,
                        statusModerateOperator: page.status_moderate_operator,
                        version: page.version
                    };
                });
            }

            if (data.ad_type === 'content_promotion') {
                switch (data.content_promotion_content_type) {
                    case 'video':
                        data.description = data.body;
                        data.video_href = data.content_promotion_url;
                        data.video_preview_image_href = data.content_promotion_preview_url;
                        data.content_promotion_video_id = data.content_promotion_content_id;
                        if (data.content_promotion_content_id) {
                            data.video_href_checked = true;
                        }
                        break;

                    case 'collection':
                        data.collection_href = data.content_promotion_url;
                        data.collection_preview_image_href = data.content_promotion_preview_url;
                        data.content_promotion_collection_id = data.content_promotion_content_id;
                        if (data.content_promotion_content_id) {
                            data.collection_href_checked = true;
                        }

                        break;
                }
                data.ad_type = 'content_promotion';
            }

            if (group.adgroup_type === 'cpm_yndx_frontpage') {
                data.ad_type = 'cpm_yndx_frontpage';
            }

            data.has_site_enum = 'yes';
            if (['text', 'image_ad', 'cpc_video', 'cpm_yndx_frontpage', 'cpm_banner'].indexOf(data.ad_type) !== -1 && !data.href_model.href && data.turbolanding) {
                data.has_site_enum = 'no';
            }

            data.prefer_vcard_over_permalink = banner.prefer_vcard_over_permalink == 1;

            return data;
        }
    });

    /**
     * Обработка данных для случая, когда данные приходят в модель минуя обработчик u.bannerData
     * Это происходит при отработке ajax-запроса getAdGroup в показе превью группы
     * @param {Object} data
     * @returns {Object}
     */
    function prepareDataFromAjax(data) {
        data.modelId = data.modelId || data.bid;
        data.modelId && (data.sitelinks.modelId = data.modelId);

        //в превью групп, где в выдаче запроса getAdGroup не приходит isVCardEmpty
        data.isVCardEmpty = data.isVCardEmpty === undefined ?
            !data.vcard_id && !data.phone && u._.isEmpty(data.vcard) :
            data.isVCardEmpty;

        data.is_vcard_open = data.is_vcard_open === undefined ?
            !data.isVCardEmpty :
            data.is_vcard_open;

        data.has_vcard = data.has_vcard === undefined ?
            +(!data.isVCardEmpty) :
            data.has_vcard;

        return data;
    }
})();
